import { Dict } from '@sage/xtrem-shared';
import * as ts from 'typescript';
/**
 * Top-level TS visitor
 * @param prefix prefix for translation keys
 */
export declare const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext, nodePrefix?: string) => (node: ts.Node) => ts.Node;
export declare function getOperationDecoratorParameters(filename: string, node: ts.Decorator): any[] | undefined;
/**
 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
 *
 * @param ctx transformation context
 * @returns the transformed file
 */
export declare function nodePropertyNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
//# sourceMappingURL=node-property-name-extractor.d.ts.map