"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTranslationFiles = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const fs = require("fs");
const glob = require("glob");
const lodash_1 = require("lodash");
const utils_1 = require("../utils");
const transformer_utils_1 = require("./transformer-utils");
const mergeTranslationFiles = (dir) => {
    const currents = transformer_utils_1.literalsCache[dir] || (0, xtrem_shared_1.createDictionary)();
    const baseFilePath = `${dir}/lib/i18n/base.json`;
    const originalBaseFileContent = (0, transformer_utils_1.sortByKey)(fs.existsSync(baseFilePath) ? JSON.parse(fs.readFileSync(baseFilePath, 'utf-8')) : {});
    const baseFiles = glob.sync('./lib/i18n/base.*.json', { cwd: dir, absolute: true, realpath: true });
    const baseKeys = baseFiles.reduce((previousValue, filePath) => {
        const fileContent = fs.readFileSync(filePath, 'utf-8');
        fs.unlinkSync(filePath);
        return (0, transformer_utils_1.merge)(previousValue, JSON.parse(fileContent));
    }, currents);
    const updatedBaseContent = (0, transformer_utils_1.sortByKey)(baseKeys);
    const stringsToRemove = (0, lodash_1.without)(Object.keys(originalBaseFileContent), ...Object.keys(updatedBaseContent));
    const stringsToUpdate = Object.keys(updatedBaseContent).filter(key => updatedBaseContent[key] !== originalBaseFileContent[key]);
    xtrem_shared_1.supportedLocales
        .filter(locale => locale !== 'base')
        .forEach(locale => {
        const localFilePath = `${dir}/lib/i18n/${locale}.json`;
        const localeFileContent = fs.existsSync(localFilePath)
            ? JSON.parse(fs.readFileSync(localFilePath, 'utf-8'))
            : {};
        const nextLocaleContent = (0, transformer_utils_1.excludeProperties)(localeFileContent, stringsToRemove);
        stringsToUpdate.forEach(key => {
            nextLocaleContent[key] = '';
        });
        (0, utils_1.saveAsJson)(localFilePath, (0, transformer_utils_1.sortByKey)(nextLocaleContent));
    });
    (0, utils_1.saveAsJson)(baseFilePath, (0, transformer_utils_1.sortByKey)(updatedBaseContent));
};
exports.mergeTranslationFiles = mergeTranslationFiles;
//# sourceMappingURL=merge-translation-files.js.map