/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.streamRequestHandler=exports.abortHandler=void 0;const xtrem_core_1=require("@sage/xtrem-core"),logger=xtrem_core_1.Logger.getLogger(__filename,"chatbot-router"),abortHandler=(e,r)=>{const t=new AbortController,handleClientDisconnect=r=>{if(logger.verbose(()=>`Client disconnected from streaming chat: ${r} ${e.url}`),!t.signal.aborted)logger.verbose(()=>`Aborting streaming request due to client disconnect: ${e.url}`),t.abort()};e.on("aborted",()=>handleClientDisconnect("request aborted")),e.on("error",()=>handleClientDisconnect("request error"));const o=setInterval(()=>{if(r.socket?.destroyed||r.writableEnded||r.writableAborted||r.writableFinished)logger.verbose(()=>`Streaming request cancelled, aborting: ${e.url}`),handleClientDisconnect("client cancel"),logger.verbose(()=>"clearing abortCheckInterval"),clearInterval(o)},1e3),cleanup=()=>{clearInterval(o)};return e.on("close",cleanup),r.on("finish",cleanup),t};exports.abortHandler=abortHandler;const streamRequestHandler=async(e,r,t,o)=>{const n=(0,exports.abortHandler)(e,r);r.writeHead(200,{"Content-Type":"text/event-stream","Cache-Control":"no-cache, no-store, must-revalidate",Pragma:"no-cache",Expires:"0",Connection:"keep-alive","X-Accel-Buffering":"no","Access-Control-Allow-Origin":"*","Access-Control-Allow-Headers":"Cache-Control"}),r.write('data: {"type":"connected"}\n\n');const a=r.flush?.bind(r)??(()=>{});a();const onEvent=e=>{r.write(`data: ${JSON.stringify(e)}\n\n`),a()};try{await t(onEvent,n.signal)}catch(r){logger.warn(`Request stream error ${e.url}: ${r.message}\n${r.stack}`),onEvent({type:"error",error:r}),await(o?.(r))}r.end()};exports.streamRequestHandler=streamRequestHandler;
//# sourceMappingURL=request-utils.js.map