export interface ChatbotConfig {
    provider: 'anthropic' | 'bedrock';
    infer: {
        model: string;
        max_tokens: number;
        temperature: number;
        top_p: number;
    };
    summarize: {
        model: string;
        max_tokens: number;
        temperature: number;
        top_p: number;
    };
    maxWindowTokens: number;
    rateLimit: {
        maxTokensPerMinute: number;
    };
    anthropic: {
        apiKey?: string;
    };
    bedrock: {
        region: string;
    };
}
export interface ChatbotConfigExtension {
    chatbotService?: ChatbotConfig;
}
declare module '@sage/xtrem-shared/lib/config' {
    interface Config extends ChatbotConfigExtension {
    }
}
export declare const defaultChatbotConfig: {
    provider: "bedrock";
    infer: {
        model: string;
        max_tokens: number;
        temperature: number;
        top_p: number;
    };
    summarize: {
        model: string;
        max_tokens: number;
        temperature: number;
        top_p: number;
    };
    maxWindowTokens: number;
    rateLimit: {
        maxTokensPerMinute: number;
    };
    anthropic: {
        apiKey: undefined;
    };
    bedrock: {
        region: string;
    };
};
export declare function getConfig(): ChatbotConfig;
//# sourceMappingURL=config.d.ts.map