import { ChatbotAccess } from '@sage/xtrem-core';
export type StreamEvent = {
    type: 'connected';
} | {
    type: 'thinking';
    message: string;
} | {
    type: 'tool_use';
    toolName: string;
    input: any;
} | {
    type: 'tool_result';
    toolName: string;
    result: any;
    status: 'completed' | 'error';
} | {
    type: 'text_chunk';
    text: string;
} | {
    type: 'completed';
    finalText: string;
    conversationId: string;
    timestamp?: string;
    timeToFirstTokenMs?: number;
    timeToLastTokenMs?: number;
} | {
    type: 'access';
    access: ChatbotAccess;
} | {
    type: 'error';
    error: string;
};
export type ClientType = 'bedrock' | 'anthropic';
//# sourceMappingURL=client-interface.d.ts.map