/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ClientFactory=void 0;const xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),anthropic_client_1=require("./anthropic-client"),bedrock_client_1=require("./bedrock-client"),logger=xtrem_log_1.Logger.getLogger(__filename,"client-factory");class ClientFactory{static createClient(e,r){switch(logger.debug(()=>`Creating ${r.provider} client`),r.provider){case"anthropic":return new anthropic_client_1.AnthropicClient(e,r.modelId);case"bedrock":return new bedrock_client_1.BedrockClient(e,r.modelId);default:throw new xtrem_shared_1.ConfigurationError(`Unknown provider: ${r.provider}`)}}}exports.ClientFactory=ClientFactory;
//# sourceMappingURL=client-factory.js.map