/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getChatRouter=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_i18n_1=require("@sage/xtrem-i18n"),express=require("express"),lodash_1=require("lodash"),multer=require("multer"),client_factory_1=require("./client-factory"),request_utils_1=require("./request-utils"),logger=xtrem_core_1.Logger.getLogger(__filename,"chatbot-router"),getChatRouter=e=>{const t=express.Router(),r=multer.memoryStorage(),o=multer({storage:r,limits:{fileSize:524288},fileFilter:(e,t,r)=>{if(t.mimetype.startsWith("audio/"))r(null,true);else logger.warn(`Rejected non-audio file upload: ${t.originalname} (${t.mimetype})`),r(new Error("Only audio files are allowed"))}});return t.post("/transcribe",o.single("audio"),async(t,r)=>{const o=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers),a=r.locals.config,{sampleRate:s}=t.body,n=t.file?.buffer;if(!n||(0,lodash_1.isNil)(s))return logger.warn("Missing required fields in transcription request"),void r.status(400).json("Missing required fields: audio file, sampleRate");const i=xtrem_core_1.CoreHooks?.getChatbotManager(e);if(!i)return logger.warn("Chatbot manager not available"),void r.status(503).json("Chatbot manager not available");const l=i.transcribeAudioChunk;if(!l)return logger.warn("Transcription service not available"),void r.status(503).json("Transcription service not available");await e.withReadonlyContext((0,xtrem_core_1.getTenantId)(e,a),async e=>{if(!(await i.getChatbotAccess(e)).isAllowed)return void r.status(403).json({error:"Copilot usage is not allowed for this user"});await(0,request_utils_1.streamRequestHandler)(t,r,async e=>{await l({audioBuffer:n,sampleRate:Number(s),language:o,onProgress:({text:t,isFinal:r})=>{if(logger.verbose(()=>`Transcription progress: ${t}`),r)e({type:"completed",finalText:t,conversationId:""});else e({type:"text_chunk",text:t})}})})},{config:a,locale:o,request:t,response:r})}),t.get("/conversation-starter",async(t,r)=>{const o=r.locals.config,a=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers);await e.withReadonlyContext((0,xtrem_core_1.getTenantId)(e,o),async t=>{const o=xtrem_core_1.CoreHooks?.getChatbotManager(e);if(!o)return logger.warn("Chatbot manager not available"),void r.status(503).json("Chatbot manager not available");const a=await(xtrem_core_1.CoreHooks?.getChatbotManager(e).getChatbotAccess(t));if(!a.isAllowed)return void r.status(403).json({error:"Copilot usage is not allowed for this user"});if(!a.usage?.infer)throw new Error("Missing infer model");const s=client_factory_1.ClientFactory.createClient(t,a.usage.infer),n=await s.generateStarterQuestions();r.json(n)},{config:o,locale:a,request:t,response:r})}),t.get("/access",async(t,r)=>{const o=r.locals.config,a=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers);await e.withReadonlyContext((0,xtrem_core_1.getTenantId)(e,o),async t=>{const o=xtrem_core_1.CoreHooks?.getChatbotManager(e);if(!o)return logger.warn("Chatbot manager not available"),void r.status(503).json("Chatbot manager not available");const a=await(xtrem_core_1.CoreHooks?.getChatbotManager(e).getChatbotAccess(t));if(!a.isAllowed)return void r.status(403).json({error:"Copilot usage is not allowed for this user"});if(!a.usage?.infer)throw new Error("Missing infer model");r.json(a)},{config:o,locale:a,request:t,response:r})}),t.get("/conversation-history",async(t,r)=>{const o=r.locals.config,a=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers);await e.withReadonlyContext((0,xtrem_core_1.getTenantId)(e,o),async t=>{const o=xtrem_core_1.CoreHooks?.getChatbotManager(e);if(!o)return logger.warn("Chatbot manager not available"),void r.status(503).json("Chatbot manager not available");if(!(await o.getChatbotAccess(t)).isAllowed)return void r.status(403).json({error:"Copilot usage is not allowed for this user"});const a=await o.getConversationHistory(t);r.json(a)},{config:o,locale:a,request:t,response:r})}),t.post("/stream",async(t,r)=>{const o=r.locals.config,a=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers),s=t.body.messages,n=t.body.context||{},i=t.body.conversationId;await e.withReadonlyContext((0,xtrem_core_1.getTenantId)(e,o),async o=>{const a=await(xtrem_core_1.CoreHooks?.getChatbotManager(e).getChatbotAccess(o));if(!a.isAllowed)throw new Error("User is not allowed to access the chatbot");if(!a.usage?.infer)throw new Error("Missing infer model");const l=(await o.user)?.email,c=client_factory_1.ClientFactory.createClient(o,a.usage.infer);logger.verbose(()=>`Streaming chat request context: ${o.tenantId}, ${l}`);let g=i;await(0,request_utils_1.streamRequestHandler)(t,r,async(e,t)=>{logger.verbose(()=>`Processing streaming chat request with abort signal: ${!!t}, aborted: ${t?.aborted}`),s[s.length-1].timestamp=(new Date).toISOString(),g=await c.createOrUpdateConversation(s,i),await c.callStreaming(s,n,e,g,t)},async e=>{if(logger.error(`Error during streaming chat: ${e.stack||e.message}`),g)await c.setConversationFailed(g)})},{config:o,locale:a,request:t,response:r,source:"customMutation"})}),t};exports.getChatRouter=getChatRouter;
//# sourceMappingURL=chat-route.js.map