/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.BaseClient=exports.logger=void 0;const index_js_1=require("@modelcontextprotocol/sdk/client/index.js"),inMemory_js_1=require("@modelcontextprotocol/sdk/inMemory.js"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_mcp_1=require("@sage/xtrem-mcp"),xtrem_shared_1=require("@sage/xtrem-shared"),limiter_1=require("limiter"),_=require("lodash"),config_1=require("./config");exports.logger=xtrem_log_1.Logger.getLogger(__filename,"chatbot-client");class BaseClient{static{this.inputLimiter=new limiter_1.RateLimiter({tokensPerInterval:(0,config_1.getConfig)().rateLimit.maxTokensPerMinute,interval:"minute"})}constructor(e,t,n){this.context=e,this.client=t,this.config=(0,config_1.getConfig)(),this.config.infer.model=n}static createPageContextMessage(e){if(e?.screenTitle&&e?.nodeName&&e?.recordId)return`The user is on page "${e.screenTitle}", which is bound to the node "${e.nodeName}" with the following \`_id\`: ${JSON.stringify(e?.recordId)}.`;if(e?.nodeName)return`The user is on to page "${e?.screenTitle}", which is bound to the node "${e?.nodeName}".`;if(e?.screenTitle)return`The user is on to page "${e?.screenTitle}".`;return null}static async withRetry(e,t=3){for(let n=1;n<=t;n++)try{return await e()}catch(e){if(!("overloaded_error"===e?.error?.type||529===e?.status||e?.message?.includes("overloaded")))throw e;const o=Math.min(1e3*2**(n-1),1e4);exports.logger.warn(`Claude overloaded (attempt ${n}/${t}), retrying in ${o}ms...`),await new Promise(e=>{setTimeout(e,o)})}throw new Error("Max retries exceeded")}async init(){if(!this.mcpClient){exports.logger.info("Initializing MCP server");const e=xtrem_core_1.ConfigManager.current.app;if(!e)throw new xtrem_shared_1.ConfigurationError("No app in config. You did not activate multi-app. Copy xtrem-config-template.yml to xtrem-config.yml at the root of your app");const t=(await this.context.loginUser)?.email,n=this.context.tenantId;if(!n)throw new xtrem_shared_1.ConfigurationError("No tenant ID in context");const o=(await this.context.user)?.email??t;if(!o)throw new xtrem_shared_1.ConfigurationError("No user email in context");const r={tenantId:n,sourceUserEmail:o,appName:e,login:t,scope:"sourceUser",expiresIn:"10m"};if(this.context.remoteContext)r.remoteContext={...this.context.remoteContext};const s=await xtrem_core_1.InteropGraphqlClient.getBearerToken(r),a=await xtrem_core_1.CoreHooks.getChatbotManager(this.context.application).supportedExportListTypes(this.context),i=xtrem_core_1.InteropGraphqlClient.getInteropUrl(e),c=this.context.application.isProxy;this.mcpServer=await xtrem_mcp_1.McpServerHelper.create({applicationName:e,endpoint:i,tenantId:n,userEmail:o,userLocale:this.context.currentLocale||"en-US",bearerToken:s,documentationServiceUrl:xtrem_core_1.ConfigManager.current.documentationServiceUrl,exportListOptions:{exportList:xtrem_core_1.CoreHooks.getChatbotManager(this.context.application).exportList,supportedExportListTypes:a},isProxy:c});const[l,u]=inMemory_js_1.InMemoryTransport.createLinkedPair();await this.mcpServer.server.connect(u),exports.logger.info("Initializing MCP client"),this.mcpClient=new index_js_1.Client({name:"xtrem-chatbot-client",version:"1.0.0"},{capabilities:{}}),await this.mcpClient.connect(l),exports.logger.info("MCP client with memory transport enabled for chatbot client")}return this}async getAvailableTools(){if(!this.mcpClient)return;try{return(await this.mcpClient.listTools()).tools.map(e=>({name:e.name,description:e.description,input_schema:e.inputSchema,cache_control:e.annotations?.cache_control}))}catch(e){return void exports.logger.error(()=>`Failed to get MCP tools: ${e.message}`)}}static getBlockLength(e){if("string"==typeof e)return e.length;switch(e.type){case"text":return e.text.length;case"image":return 1;case"tool_use":return"string"==typeof e.input?e.input.length:JSON.stringify(e.input).length;case"tool_result":return this.getMessageLength(e.content??"");default:return 0}}static getMessageLength(e){if("string"==typeof e)return e.length;return e.reduce((e,t)=>e+BaseClient.getBlockLength(t),0)}static getTokenCount(e){return Math.floor(e/4)}static estimateInputTokens(e){const t=e.reduce((e,t)=>e+this.getMessageLength(t.content),0);return BaseClient.getTokenCount(t)}static async spy(e,t){const n=Date.now();try{return await t()}finally{const t=Date.now()-n;exports.logger.debug(()=>`MCP ${e} took ${t}ms`)}}async send(e,t,n,o){const r=BaseClient.estimateInputTokens(t);await BaseClient.spy(`inputLimiter: ${r}`,()=>BaseClient.inputLimiter.removeTokens(r));const s=this.client.messages.stream({...this.config.infer,tools:e.tools,messages:t});return s.on("text",e=>{if(o?.aborted)throw exports.logger.verbose(()=>"Chat client sendStreaming: abort signal detected during text streaming"),s.abort(),new Error("Operation was cancelled");n({type:"text_chunk",text:e})}),s.finalMessage()}async pushTurn(e,t){e.window.push(t);if(JSON.stringify(e.window).length/4>e.maxWindowTokens){const t=e.window.splice(Math.floor(e.window.length/2)),n=e.window,o=await this.summarize(n,e.system);e.summary=e.summary?`${e.summary}\n\n${o}`:o,e.window=t}}static buildMessages(e){const t=[];if(e.summary)t.push({role:"assistant",content:`Conversation so far (summary): ${e.summary}`});return t.push(...e.window),t}async sendStreaming(e,t,n){if(n?.aborted)throw exports.logger.verbose(()=>"Chat client sendStreaming: abort signal already aborted"),new Error("Operation was cancelled");exports.logger.verbose(()=>`Chat client sendStreaming: received abort signal: ${!!n}, aborted: ${n?.aborted}`);const o=BaseClient.buildMessages(e);exports.logger.debug(()=>`Sending streaming messages to Claude with context: ${JSON.stringify(o,xtrem_mcp_1.ellipsesReplacer,2)}}`);const r=await BaseClient.withRetry(async()=>this.send(e,o,t,n));return exports.logger.debug(()=>`Final streamed message: ${JSON.stringify(r,xtrem_mcp_1.ellipsesReplacer,2)}}`),r}async stepStreaming(e,t,n,o){if(!this.mcpClient)throw new Error("MCP client not initialized but tool use detected");if(n?.aborted)throw exports.logger.verbose(()=>"Chat client stepStreaming: abort signal already aborted"),new Error("Operation was cancelled");exports.logger.verbose(()=>`Chat client stepStreaming: received abort signal: ${!!n}, aborted: ${n?.aborted}`),t({type:"thinking",message:"Processing request..."});const r=BaseClient.createPageContextMessage(e.pageContext);if(r)e.window.push({role:"assistant",content:r});const s=await this.sendStreaming(e,t,n);await this.pushTurn(e,{role:"assistant",content:s.content});const a=s.content.find(e=>"tool_use"===e.type);if(!a)return{...s,usage:{...s.usage,input_tokens:(o?.input_tokens??0)+(s.usage?.input_tokens??0),output_tokens:(o?.output_tokens??0)+(s.usage?.output_tokens??0),cache_creation_input_tokens:(o?.cache_creation_input_tokens??0)+(s.usage?.cache_creation_input_tokens??0),cache_read_input_tokens:(o?.cache_read_input_tokens??0)+(s.usage?.cache_read_input_tokens??0)}};if(t({type:"tool_use",toolName:a.name,input:a.input}),n?.aborted)throw exports.logger.verbose(()=>"Chat client stepStreaming: abort signal detected before tool execution"),new Error("Operation was cancelled");const i=await this.mcpClient.callTool({name:a.name,arguments:a.input});if(n?.aborted)throw exports.logger.verbose(()=>"Chat client stepStreaming: abort signal detected after tool execution"),new Error("Operation was cancelled");const c={role:"user",content:[{type:"tool_result",tool_use_id:a.id,content:i.content,is_error:i.isError}]};return await this.pushTurn(e,c),t({type:"tool_result",toolName:a.name,result:i.content,status:i.isError?"error":"completed"}),t({type:"text_chunk",text:"\n#  \n"}),exports.logger.verbose(()=>`Chat client stepStreaming: making recursive call with abort signal: ${!!n}, aborted: ${n?.aborted}`),this.stepStreaming(e,t,n,{...s.usage,input_tokens:(o?.input_tokens??0)+(s.usage?.input_tokens??0),output_tokens:(o?.output_tokens??0)+(s.usage?.output_tokens??0),cache_creation_input_tokens:(o?.cache_creation_input_tokens??0)+(s.usage?.cache_creation_input_tokens??0),cache_read_input_tokens:(o?.cache_read_input_tokens??0)+(s.usage?.cache_read_input_tokens??0)})}async summarize(e,t){const n=e.map(e=>({role:e.role,content:e.content}));return(await BaseClient.withRetry(async()=>this.client.messages.create({...this.config.summarize,system:t,messages:[{role:"user",content:"Summarize these turns with key facts, decisions, and tool outcomes:"},{role:"user",content:JSON.stringify(n).slice(0,4e4)}]}))).content.map(e=>e.text||"").join("\n")}generateConversationTitle(e){const t=e[0]?.content||"";return BaseClient.withRetry(async()=>{const e=await this.client.messages.create({...this.config.infer,max_tokens:2e3,messages:[{role:"user",content:`\n                    The following sentence is the first question of an AI assistant conversation, please write a summary title (max 32 characters) for the conversation based on the following initial question, the response must not contain anything else but the summary.\n\n                    ${t}`}]});if("text"!==e.content[0].type)throw new Error("Unexpected non-JSON response from Claude when generating starter questions");try{return e.content[0].text}catch{throw new Error("Unexpected non-JSON response from Claude when generating starter questions")}})}async generateStarterQuestions(){const e=await(xtrem_core_1.CoreHooks.getChatbotManager(this.context.application)?.getUserGroupNames(this.context)),t=!_.isEmpty(e)?`The user has the following group assignment, so try to make the questions relevant to these: ${e.join(", ")}.`:"",n=this.context.application.getAllSortedFactories().map(e=>e.name);return BaseClient.withRetry(async()=>{const e=await this.client.messages.create({...this.config.infer,max_tokens:2e3,messages:[{role:"user",content:`\n                    You must generate exactly 3 conversation starter questions for a chatbot for an ERP business management system called "${this.context.configuration.getProductName()}".\n                    This chatbot is capable of answering questions about the data it manages. The product manages the following business objects ${n.join(", ")}. The questions must be relevant to these business objects. ${t}\n                    They should not be very complex, but rather simple and easy to understand by a typical user of the product.\n                    The questions must be simple analytical questions about the data that the system holds.\n                    The response must be pure formatted as a valid JSON array of the questions. IT MUST NOT CONTAIN ANY OTHER FORMATTING.`}]});if("text"!==e.content[0].type)throw new Error("Unexpected non-JSON response from Claude when generating starter questions");try{return JSON.parse(e.content[0].text)}catch{throw new Error("Unexpected non-JSON response from Claude when generating starter questions")}})}async createOrUpdateConversation(e,t,n){return xtrem_core_1.CoreHooks.getChatbotManager(this.context.application).createOrUpdateConversation(this.context,{id:t,messages:[...e],title:!t?await this.generateConversationTitle(e):void 0,inputTokensUsed:n?.input_tokens,outputTokensUsed:n?.output_tokens,cacheCreationTokensUsed:n?.cache_creation_input_tokens??0,cacheReadTokensUsed:n?.cache_read_input_tokens??0})}async setConversationFailed(e){try{await xtrem_core_1.CoreHooks.getChatbotManager(this.context.application).createOrUpdateConversation(this.context,{id:e,isFailed:true})}catch(t){exports.logger.error(()=>`Failed to mark conversation ${e} as failed: ${t.message}`)}}async checkChatbotAccess(e){const t=await xtrem_core_1.CoreHooks.getChatbotManager(this.context.application).getChatbotAccess(this.context);return e({type:"access",access:t}),t.isAllowed&&!t.usage?.blockedUntil}static getStarterPrompt(){return`Provide direct, minimal answers without showing your work or reasoning steps unless explicitly requested.\nFocus only on the final answer the user needs.\nThe current date is ${xtrem_date_time_1.DateValue.today().toString()}\n\nYou may use "hyperchat links" in your answers.\nA "hyperchat link" is a special link with an href starting with /hyperchat/ and followed by a base64-encoded prompt.\nIt looks like this: <a href="/hyperchat/{{base64_prompt}}">action title {{emoji}}</a>.\nThe emoji will help the user differentiate these links from regular links. You may use any emoji that fits the action.\nOnly use an emoji on hyperchat links, leave regular links without emojis.\n\nUse these links to suggest contextual follow-up actions that the user can click on to start or continue a process.\nWhen displaying lists of items, place the links next to the relevant items, so the user can take action on that specific item.\nDo not limit yourself to navigational links, but also suggest links that execute mutations, for example to approve a document or to launch a process.\n\nIf an action cannot be completed without asking the user to select an option among a small set of choices,\nyou can include a set of "hyperchat links" at the end of your response, one for each choice.\n`}async callStreaming(e,t,n,o,r){if(r?.aborted)throw new Error("Operation was cancelled");await this.init();const s=performance.now(),a={},i=this.mcpClient?await this.getAvailableTools()??[]:[];if(!await this.checkChatbotAccess(n)){const t="Cannot continue the conversation now. Retry later...",r={role:"assistant",content:[{type:"text",text:t}]};return await this.createOrUpdateConversation([...e,{...r,timestamp:(new Date).toISOString()}],o),n({type:"text_chunk",text:t}),void n({type:"completed",finalText:t,conversationId:o,timestamp:(new Date).toISOString()})}const c=await this.stepStreaming({system:"",tools:i,window:[{role:"user",content:BaseClient.getStarterPrompt()},...e.map(e=>({role:e.role,content:e.content}))],maxWindowTokens:this.config.maxWindowTokens,pageContext:t},e=>{if("text_chunk"===e.type&&!a.timeToFirstTokenMs)a.timeToFirstTokenMs=performance.now()-s;n(e)},r),l=(new Date).toISOString(),u=c.content.filter(e=>"text"===e.type).map(e=>e.text).join("\n");a.timeToLastTokenMs=performance.now()-s,n({type:"completed",finalText:u,conversationId:o,timestamp:l,...a}),await this.createOrUpdateConversation([...e,{...c,...a,timestamp:l}],o,c.usage),await this.checkChatbotAccess(n)}async cleanup(){if(this.mcpClient){try{await this.mcpClient.close(),exports.logger.info("MCP client closed")}catch(e){exports.logger.error(()=>`Error closing MCP client: ${e.message}`)}this.mcpClient=void 0}if(this.mcpServer)try{await this.mcpServer.close(),exports.logger.info("MCP server closed")}catch(e){exports.logger.error(()=>`Error closing MCP server: ${e.message}`)}}}exports.BaseClient=BaseClient;
//# sourceMappingURL=base-client.js.map