import AnthropicBedrock from '@anthropic-ai/bedrock-sdk';
import Anthropic from '@anthropic-ai/sdk';
import type { MessageParam, Usage } from '@anthropic-ai/sdk/resources';
import { Context } from '@sage/xtrem-core';
import { Logger } from '@sage/xtrem-log';
import { StreamEvent } from './client-interface';
import { PageContext } from './utils';
export declare const logger: Logger;
interface ResponseMetrics {
    timeToFirstTokenMs?: number;
    timeToLastTokenMs?: number;
}
export interface MessageParamWithTimestamp extends MessageParam, ResponseMetrics {
    timestamp?: string;
}
type ContentItem = MessageParam['content']['0'];
type BlockParam = Exclude<ContentItem, string>;
type Turn = {
    role: 'user' | 'assistant';
    content: BlockParam[] | string;
};
export interface Ctx {
    system: string;
    tools: Anthropic.Tool[];
    window: Turn[];
    summary?: string;
    maxWindowTokens: number;
    pageContext?: PageContext;
}
export declare abstract class BaseClient {
    private context;
    private client;
    private mcpClient?;
    private mcpServer?;
    private config;
    private static inputLimiter;
    constructor(context: Context, client: Anthropic | AnthropicBedrock, inferModelId: string);
    private static createPageContextMessage;
    private static withRetry;
    private init;
    private getAvailableTools;
    private static getBlockLength;
    private static getMessageLength;
    private static getTokenCount;
    private static estimateInputTokens;
    static spy<T>(name: string, fn: () => Promise<T>): Promise<T>;
    send(ctx: Ctx, messages: MessageParam[], onEvent: (event: StreamEvent) => void, abortSignal?: AbortSignal): Promise<Anthropic.Messages.Message>;
    /** Add a turn into ctx.window, truncating old ones; keep a rolling summary */
    private pushTurn;
    /** Small helper to build the messages payload each turn */
    private static buildMessages;
    /** Enhanced streaming send with native Anthropic streaming */
    private sendStreaming;
    /** Handle a tool chain step with streaming events */
    private stepStreaming;
    private summarize;
    generateConversationTitle(messages: MessageParam[]): Promise<string>;
    generateStarterQuestions(): Promise<string[]>;
    createOrUpdateConversation(messages: MessageParamWithTimestamp[], conversationId?: string, tokensUsage?: Usage): Promise<string>;
    setConversationFailed(conversationId: string): Promise<void>;
    checkChatbotAccess(onEvent: (event: StreamEvent) => void): Promise<boolean>;
    private static getStarterPrompt;
    callStreaming(messages: MessageParamWithTimestamp[], pageContext: PageContext, onEvent: (event: StreamEvent) => void, conversationId: string, abortSignal?: AbortSignal): Promise<void>;
    /**
     * Cleanup MCP resources (call this when shutting down the application)
     */
    cleanup(): Promise<void>;
}
export {};
//# sourceMappingURL=base-client.d.ts.map