/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremWorker=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_service_1=require("@sage/xtrem-service"),xtrem_shared_1=require("@sage/xtrem-shared"),nanoid_1=require("nanoid"),logger=new xtrem_core_1.Logger(__filename,"cli");class XtremWorker{#e;#r;#t=false;#s;#i;#o;#a=0;#n=0;constructor(e,r){this.initWorkerId=e,this.cluster=r,this.#o=e}get workerId(){return this.#o}init(){return this.fork(),this}fork(){this.#t=false,this.#e=void 0,this.resetActiveRequests(),this.#r=this.cluster.fork({XTREM_WORKER_ID:this.workerId}),this.promise=new Promise((e,r)=>{this.#s=e,this.#i=r});const e=1e3*(0,xtrem_core_1.graphQlTimeLimitInSeconds)()-500,r=setTimeout(()=>{this.#i(new Error(`Failed to start worker with worker id ${this.workerId}`))},e);logger.info(`Forked worker for ${this.workerId}(pid: ${this.#r.process.pid})`),this.#r.on("message",e=>{(async()=>{try{if(!e||"object"!=typeof e)return void logger.warn(`Invalid message received from worker ${this.workerId}: ${JSON.stringify(e)}`);if("listening"===e.event&&e.workerId===this.initWorkerId){if("number"!=typeof e.port||e.port<=0)throw new Error(`Invalid port received from worker ${this.workerId}: ${e.port}`);this.#e=e.port,this.#t=true,clearTimeout(r),this.#s(),logger.info(`Worker ${this.workerId} is ready and listening on port ${e.port}`)}else if("killWorkers"===e.event){if(!e.requestSource||"string"!=typeof e.requestSource)throw new Error(`Invalid requestSource for killWorkers from worker ${this.workerId}: ${e.requestSource}`);logger.info(`Worker ${this.workerId} requesting to kill workers for source: ${e.requestSource}`),await XtremWorker.killWorkers(e.requestSource)}else if(e.event)logger.debug(()=>`Unhandled message event from worker ${this.workerId}: ${e.event}`)}catch(r){const t=r instanceof Error?r.message:String(r),s=r instanceof Error?r.stack:void 0;if(logger.error(`Worker message handler error for ${this.workerId}: ${t}. Stack: ${s}. Message: ${JSON.stringify(e)}. WorkerPid: ${this.#r.process.pid}`),"listening"===e?.event&&!this.#t)this.#i(r);throw r}})().catch(r=>{const t=r instanceof Error?r.message:String(r),s=r instanceof Error?r.stack:void 0;if(logger.error(`Unhandled error in worker message listener for ${this.workerId}: ${t}. Stack: ${s}. Message: ${JSON.stringify(e)}. WorkerPid: ${this.#r.process.pid}`),!this.#t&&"listening"===e?.event)this.#i(r)})})}get worker(){if(this.workerExists)return this.#r;return this.fork(),this.#r}get index(){if(!this.worker)return-1;return this.worker.id}get isReady(){return this.#t}get workerExists(){return null!=this.#r&&!this.#r.isDead()}get port(){if(!this.#e)throw new Error(`[${this.worker}]: port not set.`);return this.#e}get activeRequestCount(){return this.#a}get lastRequestTime(){return this.#n}incrementActiveRequests(){this.#a+=1,this.#n=Date.now()}decrementActiveRequests(){this.#a=Math.max(0,this.#a-1)}resetActiveRequests(){this.#a=0,this.#n=0}static{this.workers=(0,xtrem_shared_1.createDictionary)()}static{this.activeRequests=(0,xtrem_shared_1.createDictionary)()}static startLoggingTimer(){if(this.loggingInterval)return;this.loggingInterval=setInterval(()=>{this.logWorkerHealth()},36e5)}static stopLoggingTimer(){if(this.loggingInterval)clearInterval(this.loggingInterval),this.loggingInterval=void 0}static logWorkerHealth(e){(e?[e]:Object.keys(this.workers)).forEach(e=>{const r=this.workers[e];if(!r)return;logger.info(`Worker health for source: ${e}`),logger.info(`Active workers: ${r.length}`),logger.info(`Total active requests: ${r.reduce((e,r)=>e+r.activeRequestCount,0)}`),logger.info(`Worker details: ${JSON.stringify(r.map(e=>({id:e.workerId,activeRequests:e.activeRequestCount,lastRequestTime:e.lastRequestTime,pid:e.#r.process.pid})),null,2)}`)})}static completeRequest(e,r,t){const s=this.workers[e];if(!s)return;const i=s.find(e=>e.workerId===r);if(i){if(i.decrementActiveRequests(),this.activeRequests[e])this.activeRequests[e].delete(t);logger.debug(()=>`Completed request ${t} for worker ${r}, active requests: ${i.activeRequestCount}`)}}static generateRequestId(){return(0,nanoid_1.nanoid)()}static addWorkers(e,r,t,s){if(!this.workers[r])this.workers[r]=[];for(let i=t;i<s;i+=1)this.workers[r].push(new XtremWorker(r,e).init())}static seedWorker(e,r,t=2){if((this.workers[r]??[]).length<t){const s=t-(this.workers[r]?.length??0);logger.info(`Seeding workers for ${r} with ${s} workers`),this.addWorkers(e,r,0,s)}}static{this.deferredWorkerTimeout=(0,xtrem_shared_1.createDictionary)()}static{this.seeded=false}static workersPerSource(e){return xtrem_service_1.GraphqlEndpointHooks.getSourceMaxWorkers(e)??xtrem_core_1.ConfigManager.current.server?.worker?.workersPerRequestSource??3}static seedWorkers(e){xtrem_service_1.GraphqlEndpointHooks.getSourcesToSeed().filter(e=>!this.workers[e]||0===this.workers[e].length).forEach(r=>{const t=this.workersPerSource(r);this.seedWorker(e,r,t)}),this.seeded=true,this.startLoggingTimer()}static{this.downscaleWorkerPromises=(0,xtrem_shared_1.createDictionary)()}static downscaleWorkers(){Object.keys(this.workers).forEach(e=>{this.downscaleWorkerPromises[e]=new Promise(r=>{const t=this.workers[e],s=this.workersPerSource(e);if(t.length>s){const r=t.filter(e=>0===e.activeRequestCount).slice(s);if(logger.info(`Scaling down workers for ${e}, ${r.length} workers will be removed.`),r.length>0)r.forEach(e=>e.kill())}this.logWorkerHealth(e),delete this.downscaleWorkerPromises[e],r()})})}static initializeWorkers(e,r,t){if(this.addWorkers(e,r,0,t),!this.downscaleWorkerInterval)this.downscaleWorkerInterval=setInterval(()=>{this.downscaleWorkers()},xtrem_core_1.ConfigManager.current.server?.worker?.downscale?.intervalInMillis??6e5)}static async fillRequestSource(e,r,t=false){const s=this.workersPerSource(r);let i=this.workers[r];if(!t&&i&&i.length>=s)return true;const o=xtrem_core_1.ConfigManager.current.server?.worker?.upscale?.max??Math.ceil(1.5*s);if(i&&i.length>=o)return true;let a=0;for(;!this.seeded;)if(await(0,xtrem_core_1.sleepMillis)(100),a+=1,a>10)return false;if(!i||0===i.length)this.initializeWorkers(e,r,1),i=this.workers[r];if(i.length<s||t)if(!this.deferredWorkerTimeout[r]){const t=Math.max(s-i.length,1);logger.info(`Scaling up workers for ${r}, ${t} new workers will be created.`),this.deferredWorkerTimeout[r]=setTimeout(()=>{XtremWorker.initializeWorkers(e,r,t),delete XtremWorker.deferredWorkerTimeout[r],this.logWorkerHealth(r)})}return true}static{this.upscaleWorkerPromises=(0,xtrem_shared_1.createDictionary)()}static async getNextAvailableWorker(e,r,t=false){const s=this.workers[r];if(!s||0===s.length)return;const i=s.slice();if(0===i.length)return;let o=i[0],a=o.activeRequestCount,n=o.lastRequestTime;for(let e=1;e<i.length;e+=1){const r=i[e],t=r.activeRequestCount;if(t<a)o=r,a=t,n=r.lastRequestTime;else if(t===a)if(r.lastRequestTime<n)o=r,n=r.lastRequestTime}const l=xtrem_core_1.ConfigManager.current.server?.worker?.maxRequestsPerWorker??20;if(!t&&o.activeRequestCount>=l){if(null==this.upscaleWorkerPromises[r])this.upscaleWorkerPromises[r]=(async()=>{if(await this.fillRequestSource(e,r,true)){let e=0;for(;0===this.workers[r].filter(e=>e.activeRequestCount<l).length&&(logger.warn(`No available workers for ${r} after scaling up, wait for workers to be ready`),await(0,xtrem_core_1.sleepMillis)(100),e+=1,20!==e););}})();return await this.upscaleWorkerPromises[r],delete this.upscaleWorkerPromises[r],this.getNextAvailableWorker(e,r,true)}return o.incrementActiveRequests(),logger.debug(()=>`Selected worker ${o.workerId} (${o.#r.process.pid}) with ${o.activeRequestCount} active requests (total workers: ${i.length})`),o}static async getNextWorker(e,r){if(null!=this.killWorkersPromises[r])await this.killWorkersPromises[r];if(null!=this.downscaleWorkerPromises[r])await this.downscaleWorkerPromises[r];if(!await this.fillRequestSource(e,r))return;let t;if(t=await this.getNextAvailableWorker(e,r),!t){if(!await this.fillRequestSource(e,r))return;t=await this.getNextAvailableWorker(e,r)}if(!t)return void logger.error(`Failed to find worker for request to ${r}`);if(!t.workerExists)t.fork();const s=this.generateRequestId();if(!this.activeRequests[r])this.activeRequests[r]=new Set;if(this.activeRequests[r].add(s),!t.isReady)try{return await t.promise,{worker:t,requestId:s}}catch(e){if(logger.error(e),t)this.completeRequest(r,t.workerId,s);return}return Promise.resolve({worker:t,requestId:s})}static{this.killWorkersPromises=(0,xtrem_shared_1.createDictionary)()}static{this.workerKillFunnel=(0,xtrem_core_1.funnel)(1)}kill(){if(this.resetActiveRequests(),logger.info(`killing worker: workerId=${this.#o}, pid = ${this.#r.process.pid}`),this.workerExists)try{if(this.#r.process.pid)process.kill(this.#r.process.pid),logger.info(`killed worker workerId=${this.#o}, pid = ${this.#r.process.pid}`)}catch(e){logger.error(`Error killing worker ${this.workerId} ${e.message}`)}}static async killWorkers(e){if(null!=this.killWorkersPromises[e])await this.killWorkersPromises[e];this.killWorkersPromises[e]=this.workerKillFunnel(()=>{if(this.workers[e]){const r=this.workers[e].slice();this.workers[e]=[],this.activeRequests[e]=new Set,r.forEach(e=>{e.kill()})}return Promise.resolve()}),await this.killWorkersPromises[e]}}exports.XtremWorker=XtremWorker;
//# sourceMappingURL=worker.js.map