/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.startServices=exports.startWorkerServices=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_service_1=require("@sage/xtrem-service"),http=require("http"),httpProxy=require("http-proxy"),https=require("https"),worker_1=require("./worker"),logger=new xtrem_core_1.Logger(__filename,"cli"),startWorkerServices=async e=>{await e.packageManager.validatePackageVersions(),await xtrem_core_1.Context.subscribeToCacheNotifications(e),await(0,xtrem_service_1.startApplication)(e)};exports.startWorkerServices=startWorkerServices;const startServices=async(e,r)=>{if(r.configExtensionLocation)logger.info(`Config extension provided, ${r.configExtensionLocation}`),xtrem_core_1.ConfigManager.load(e,"start",r.configExtensionLocation);const t=require("cluster"),o=xtrem_core_1.ConfigManager.current.deploymentMode;if(xtrem_core_1.allowedStartChannels.every(e=>r.channels.includes(e))&&"production"===o)logger.warn(`Starting the server with all channels active (${xtrem_core_1.allowedStartChannels}).`);const s=await xtrem_core_1.ApplicationManager.getApplication(e,{applicationType:"service",startOptions:r}),i="true"===process.env.XTREM_USE_MULTI_WORKER;if("1"===process.env.XTREM_CLUSTER_FORK&&i)throw new Error("Cluster mode cannot be used with multi-service workers.");if(t.isPrimary)if(i)return startProxyService(t);if(t.isWorker)if(i&&!process.env.XTREM_WORKER_ID)throw new Error(`Worker ID not supplied for worker ${process.pid}`);return(0,exports.startWorkerServices)(s)};function getFullUrl(e,r){return`${e.headers["x-forwarded-proto"]||r?.server?.ssl?"https":"http"}://${e.headers.host}${e.url}`}function isAggregateError(e){return void 0!==e.errors}function startProxyService(e){const r=xtrem_core_1.ConfigManager.current;e.on("exit",(e,r,t)=>{if(t)logger.info(`worker ${e.process.pid} was killed by signal: ${t}`);else if(0!==r)logger.info(`worker ${e.process.pid} exited with error code: ${r}`);else logger.info(`worker ${e.process.pid} successfully exited!`)});const t=httpProxy.createProxyServer();let o;t.on("error",(e,t,o)=>{const s=getFullUrl(t,r);if(isAggregateError(e)&&Array.isArray(e.errors))e.errors.forEach(e=>{logger.info(`Proxy error: ${e.stack} ${e.errno}, ${e.code}, ${e.address},${e.port})}`)});else logger.info(`Proxy error: ${e.stack} ${e.errno}, ${e.code}, ${e.address},${e.port})}`);o.setHeader("Refresh",`5;url=${s}`),o.writeHead(503,{"Content-Type":"text/plain"}),o.end("Service unavailable")});const proxyRequestHandler=async(o,s)=>{if(o.url&&/^\/ping$/.test(o.url))return s.writeHead(200,{"Content-Type":"text/plain"}),void s.end("Service available");const i=r.server?.ssl?"https":"http",n=await xtrem_service_1.GraphqlEndpointHooks.getRequestSource(o),a=await worker_1.XtremWorker.getNextWorker(e,n);if(!a){const e=getFullUrl(o,r);return logger.info(`Proxy error: Failed to find worker for request to ${n}`),s.setHeader("Refresh",`5;url=${e}`),s.writeHead(503,{"Content-Type":"text/plain"}),void s.end("Failed to find worker")}const{worker:c,requestId:l}=a;logger.info(`proxy request for ${n}`).success(`proxy request for ${n} forwarded to ${c.port} (${c.activeRequestCount} active)`);let d=false;const p=s.end;function completeRequestOnce(){if(!d)worker_1.XtremWorker.completeRequest(n,c.workerId,l),d=true}s.end=function end(...e){return completeRequestOnce(),p.apply(this,e)},s.on("close",()=>{completeRequestOnce()}),t.web(o,s,{target:`${i}://localhost:${c.port}`})},proxyListener=(e,t)=>{(async()=>{try{await proxyRequestHandler(e,t)}catch(o){if(logger.error(`Proxy request handler error: ${o instanceof Error?o.message:String(o)}, ${JSON.stringify({url:e.url,method:e.method,headers:e.headers,error:o instanceof Error?o.stack:o})}`),!t.headersSent)try{const o=getFullUrl(e,r);t.setHeader("Refresh",`5;url=${o}`),t.writeHead(500,{"Content-Type":"text/plain"}),t.end("Internal Server Error - Please try again")}catch(e){logger.error(`Failed to send error response: ${e instanceof Error?e.message:String(e)}`)}if(!t.destroyed)t.destroy()}})().catch(e=>{if(logger.error(`Unhandled error in proxy listener: ${e instanceof Error?e.message:String(e)}`),!t.destroyed&&!t.headersSent)try{t.writeHead(500,{"Content-Type":"text/plain"}),t.end("Critical Server Error")}catch{}})};if(r?.server?.ssl)o=https.createServer(r.server.ssl,proxyListener),xtrem_core_1.TlsHelper.registerTlsChangeListener(o,"server.ssl","HTTPS proxy");else o=http.createServer(proxyListener);const s=r.server?.port||8240;o.listen(s);const i=r.server?.ssl?" over TLS ":"";return logger.info(`Proxy service is listening on port ${s}${i}`),worker_1.XtremWorker.seedWorkers(e),xtrem_core_1.Application.emitter.on("killWorkers",e=>{(async()=>{try{await worker_1.XtremWorker.killWorkers(e),logger.info(`Successfully killed workers for request source: ${e}`)}catch(r){logger.error(`Error killing workers for request source ${e}: ${r}`)}})().catch(e=>{logger.error(`Unhandled error in killWorkers event handler: ${e}`)})}),Promise.resolve(void 0)}exports.startServices=startServices;
//# sourceMappingURL=start-server.js.map