import { ApplicationStartServicesOptions, StartChannel } from '@sage/xtrem-core';
import { startServices } from './start-server';
export { startServices };
export interface StartOptions {
    isUsingReferences?: boolean;
    cluster?: boolean;
    channels?: StartChannel[];
    services?: string;
    webSockets?: string;
    configExtensionLocation?: string;
    /**
     * Names of queues to explicitly start
     * If not set, all the queues will be started
     */
    queues?: string[];
}
export interface StartContext {
    dir: string;
    deployedApp: any;
    options: StartOptions;
    startServerOptions: ApplicationStartServicesOptions;
}
export declare const scriptName = ".cli-start.js";
export declare function createStartContext(options: StartOptions): StartContext;
export declare const start: (startContext: StartContext) => Promise<void>;
//# sourceMappingURL=index.d.ts.map