import { applyMiddleware, compose, createStore } from 'redux';
import { responsiveStoreEnhancer } from 'redux-responsive';
import thunk from 'redux-thunk';
import { getRootReducer } from './reducer';
export const isDevMode = () => window.location.hostname === 'sdmo-xtrem.localhost.dev-sagextrem.com' || window.DEBUGGING_XTREM;
const consoleFormat = 'color: green; font-weight: bold;';
const loggingMiddleWare = ({ getState }) => (next) => (action) => {
    if (isDevMode()) {
        const id = Date.now();
        const state = getState();
        // eslint-disable-next-line no-console
        console.log('%cDispatching', consoleFormat, id, action);
        // eslint-disable-next-line no-console
        console.log('%cState before dispatch', consoleFormat, id, state);
        const returnValue = next(action);
        const updatedState = getState();
        // eslint-disable-next-line no-console
        console.log('%cState after dispatch', consoleFormat, id, updatedState);
        window.__XTREM_STANDALONE_STATE = updatedState;
        return returnValue;
    }
    return next(action);
};
export const composeEnhancers = (isDevMode() && window && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) || compose;
function configureStore(initialState = {}) {
    const middleWares = [thunk];
    middleWares.push(loggingMiddleWare);
    const enhancer = composeEnhancers(responsiveStoreEnhancer, applyMiddleware(...middleWares));
    return createStore(getRootReducer(), initialState, enhancer);
}
const store = configureStore();
export const getStore = () => store;
//# sourceMappingURL=store.js.map