import { integration } from '@sage/xtrem-ui';
import { getInternalPathFromExternal } from '@sage/xtrem-ui-components';
import { combineReducers } from 'redux';
import { createResponsiveStateReducer } from 'redux-responsive';
import { ActionType } from './action-types';
export const path = (state = getInternalPathFromExternal(), action) => {
    switch (action.type) {
        case ActionType.SetPath:
            return action.value;
        case ActionType.SetProfile:
            return action.value ? state : '';
        default:
            return state;
    }
};
export const config = (state = null, action) => {
    if (action.type === ActionType.SetConfig) {
        return action.value;
    }
    return state;
};
export const pageTitle = (state = null, action) => {
    switch (action.type) {
        case ActionType.SetPageTitle:
            window.document.title = action.value;
            return action.value;
        default:
            return state;
    }
};
export const menuItems = (state = [], action) => {
    switch (action.type) {
        case ActionType.SetMenuItems:
            return action.value;
        case ActionType.SetProfile:
            return [];
        default:
            return state;
    }
};
export const user = (state = null, action) => {
    if (action.type === ActionType.SetUserDetails) {
        return action.value;
    }
    if (action.type === ActionType.SetMetadata) {
        return action.value.userDetails;
    }
    return state;
};
export const notifications = (state = [], action) => {
    if (action.type === ActionType.SetMetadata) {
        return action.value.notifications;
    }
    if (action.type === ActionType.SetNotifications) {
        return action.value;
    }
    return state;
};
export const loginService = (state = null, action) => {
    if (action.type === ActionType.SetLoginService) {
        return action.value;
    }
    return state;
};
export const isNavigationOpen = (state = false, action) => {
    if (action.type === ActionType.SetNavigationOpen) {
        return action.value;
    }
    return state;
};
export const isChatbotOpen = (state = false, action) => {
    if (action.type === ActionType.SetChatbotOpen) {
        return action.value;
    }
    return state;
};
export const isNotificationCenterOpen = (state = false, action) => {
    if (action.type === ActionType.SetNotificationCenterOpen) {
        return action.value;
    }
    return state;
};
export const isApplicationDirty = (state = false, action) => {
    if (action.type === ActionType.SetDirtyState) {
        return action.value?.isApplicationDirty || false;
    }
    return state;
};
export const preNavigationConfirmation = (state = null, action) => {
    if (action.type === ActionType.SetDirtyState) {
        return action.value?.preNavigationConfirmation || null;
    }
    return state;
};
export const tenantsList = (state = { oneTrustMagicLink: '', tenantList: [] }, action) => {
    if (action.type === ActionType.SetTenantsList) {
        return action.value ?? state;
    }
    if (action.type === ActionType.SetMetadata) {
        return action.value.tenantsList;
    }
    return state;
};
export const chatbotConfig = (state = null, action) => {
    if (action.type === ActionType.SetMetadata) {
        return action.value.chatbotConfig;
    }
    if (action.type === ActionType.SetChatbotConfig) {
        return action.value;
    }
    return state;
};
export const isXtremChatbotAvailable = (state = false, action) => {
    if (action.type === ActionType.SetMetadata) {
        return action.value.isXtremChatbotAvailable;
    }
    return state;
};
export const isXtremChatbotOpen = (state = false, action) => {
    if (action.type === ActionType.SetXtremChatbotOpen) {
        return action.value;
    }
    return state;
};
export const sitemap = (state = [], action) => {
    if (action.type === ActionType.SetSitemap) {
        return action.value ?? state;
    }
    if (action.type === ActionType.SetMetadata) {
        return action.value.sitemap;
    }
    return state;
};
export const translations = (state = {}, action) => {
    if (action.type === ActionType.SetMetadata) {
        return action.value.translations;
    }
    return state;
};
export const pageContext = (state = null, action) => {
    if (action.type === ActionType.SetPageContext) {
        return action.value;
    }
    return state;
};
export const browser = createResponsiveStateReducer({
    ...integration.breakpoints,
});
export const getRootReducer = () => {
    return combineReducers({
        browser,
        chatbotConfig,
        config,
        isApplicationDirty,
        isChatbotOpen,
        isNavigationOpen,
        isNotificationCenterOpen,
        isXtremChatbotAvailable,
        isXtremChatbotOpen,
        loginService,
        menuItems,
        notifications,
        pageContext,
        pageTitle,
        path,
        preNavigationConfirmation,
        sitemap,
        tenantsList,
        translations,
        user,
    });
};
//# sourceMappingURL=reducer.js.map