import type { Notification, RootMenuItem, StandaloneConfig } from '@sage/xtrem-shared';
import { integration } from '@sage/xtrem-ui';
import type { Reducer } from 'redux';
import type { IBrowser } from 'redux-responsive';
import type { UserDetails } from '../service/auth-service';
import type { ChatbotConfiguration } from '../service/chatbot-service';
import type { TenantItem } from '../service/tenants-service';
import type { AppAction } from './action-types';
import type { XtremStandaloneState } from './state';
export declare const path: (state: string | undefined, action: AppAction) => any;
export declare const config: (state: (StandaloneConfig | null) | undefined, action: AppAction) => any;
export declare const pageTitle: (state: string | null | undefined, action: AppAction) => any;
export declare const menuItems: (state: integration.Menu[] | undefined, action: AppAction) => any;
export declare const user: (state: (UserDetails | null) | undefined, action: AppAction) => any;
export declare const notifications: (state: Notification[] | undefined, action: AppAction) => any;
export declare const loginService: (state: string | null | undefined, action: AppAction) => any;
export declare const isNavigationOpen: (state: boolean | undefined, action: AppAction) => any;
export declare const isChatbotOpen: (state: boolean | undefined, action: AppAction) => any;
export declare const isNotificationCenterOpen: (state: boolean | undefined, action: AppAction) => any;
export declare const isApplicationDirty: (state: boolean | undefined, action: AppAction) => any;
export declare const preNavigationConfirmation: (state: (() => Promise<void>) | null | undefined, action: AppAction) => any;
export declare const tenantsList: (state: TenantItem | undefined, action: AppAction) => any;
export declare const chatbotConfig: (state: (ChatbotConfiguration | null) | undefined, action: AppAction) => any;
export declare const isXtremChatbotAvailable: (state: boolean | undefined, action: AppAction) => any;
export declare const isXtremChatbotOpen: (state: boolean | undefined, action: AppAction) => any;
export declare const sitemap: (state: RootMenuItem[] | undefined, action: AppAction) => any;
export declare const translations: (state: {} | undefined, action: AppAction) => any;
export declare const pageContext: (state: (integration.PageContext | null) | undefined, action: AppAction) => integration.PageContext | null;
export declare const browser: Reducer<IBrowser<integration.Breakpoints>>;
export declare const getRootReducer: () => Reducer<XtremStandaloneState, AppAction>;
//# sourceMappingURL=reducer.d.ts.map