import axios from 'axios';
import { reverse, sortBy } from 'lodash';
export const fetchTenants = async (loginServiceUrl) => {
    const response = await axios.get(`${loginServiceUrl}/api/user/tenants`, { withCredentials: true });
    const tenantItem = {
        oneTrustMagicLink: response.data?.oneTrustMagicLink,
        tenantList: reverse(sortBy(response.data?.tenants ?? [], 'lastLogin')),
    };
    return tenantItem;
};
//# sourceMappingURL=tenants-service.js.map