import axios from 'axios';
export const fetchLoginServiceUrl = async () => {
    return (await axios.get('/login-service')).data;
};
export const fetchStandaloneConfig = async (userDetails) => {
    const config = (await axios.get('/standalone-config')).data;
    if (config?.agGridLicenceKey && userDetails.email && userDetails.tenantId) {
        config.agGridLicenceKey = atob(config.agGridLicenceKey);
    }
    return config;
};
export const logPageVisit = async (historyItem) => {
    const response = await axios.post('/api', {
        query: `mutation{xtremSystem{user{logPageVisit(path:"${historyItem}")}}}`,
    });
    return response.data.data.xtremSystem.user.logPageVisit;
};
export const fetchMetaData = async (locale) => {
    const response = await axios.post('/metadata', {
        query: `{pages{key,title,category},about{application{name,version,buildStamp}},userInfo{ email, userCode, firstName,lastName,photo,bookmarks,history,uniqueUserId,uniqueTenantId,clientEncryptionKey},
                strings(filter:{packageOrPage:"@sage/xtrem-standalone"}){
                    key
                    content
                }
                notifications {
                    _id
                    _createStamp
                    actions {
                        _id
                        link
                        style
                        title
                    }
                    description
                    icon
                    isRead
                    level
                    shouldDisplayToast
                    title
               }
               sitemap {
                  id
                  title
                  isPage
                  icon
                  priority
                  children {
                    id
                    title
                    isPage
                    priority
                    children {
                      title
                      id
                      isPage
                      priority
                      children {
                        title
                        id
                        isPage
                        priority
                        children {
                          title
                          id
                          isPage
                          priority
                          children {
                            title
                            id
                            isPage
                            priority
                            children {
                              title
                              id
                              isPage
                              priority
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }`,
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    const rawVersionInfo = response.data.data?.about;
    const rowVersionParts = rawVersionInfo?.application?.version?.split('.') || [];
    const majorVersion = parseInt(rowVersionParts[0] ?? '0', 10);
    const minorVersion = parseInt(rowVersionParts[1] ?? '0', 10);
    const patchVersion = parseInt(rowVersionParts[2] ?? '0', 10);
    return {
        versionInfo: {
            majorVersion,
            minorVersion,
            patchVersion,
            buildStamp: rawVersionInfo?.application?.buildStamp,
            applicationName: rawVersionInfo?.application?.name,
        },
        userInfo: response.data.data.userInfo,
        sitemap: response.data.data.sitemap,
        notifications: response.data.data.notifications,
        translations: response.data.data.strings.reduce((prevValue, currentValue) => {
            prevValue[currentValue.key] = currentValue.content;
            return prevValue;
        }, {}),
    };
};
export const fetchNotifications = async (locale) => {
    const response = await axios.post('/metadata', {
        query: `{
                notifications {
                    _id
                    _createStamp
                    level
                    shouldDisplayToast
                    isRead
                    icon
                    title
                    description
                    actions {
                    _id
                    title
                    link
                    style
                    }
                }
            }`,
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    return response.data.data.notifications;
};
export const notificationMarkRead = async (notificationId, locale) => {
    const response = await axios.post('/metadata', {
        query: `mutation{notifications{markRead(_id:"${notificationId}")}}`,
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    return response.data.data.notifications.markRead;
};
export const notificationMarkAllRead = async (locale) => {
    const response = await axios.post('/metadata', {
        query: 'mutation{notifications{markAllRead()}}',
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    return response.data.data.notifications.markAllRead;
};
export const notificationMarkUnread = async (notificationId, locale) => {
    const response = await axios.post('/metadata', {
        query: `mutation{notifications{markUnread(_id:"${notificationId}")}}`,
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    return response.data.data.notifications.markUnread;
};
export const notificationDelete = async (notificationId, locale) => {
    const response = await axios.post('/metadata', {
        query: `mutation{notifications{delete(_id:"${notificationId}")}}`,
    }, {
        headers: {
            'Accept-Language': locale,
        },
    });
    return response.data.data.notifications.delete;
};
//# sourceMappingURL=metadata-service.js.map