import type { StandaloneConfig } from '@sage/xtrem-shared';
import type { UserDetails } from './auth-service';
export interface NavigationCategory {
    icon: string;
    title: string;
}
export interface XtremPageReference {
    key: string;
    title: string;
    category?: string;
}
export declare const fetchLoginServiceUrl: () => Promise<string>;
export declare const fetchStandaloneConfig: (userDetails: Partial<UserDetails>) => Promise<StandaloneConfig>;
export declare const logPageVisit: (historyItem: string) => Promise<any>;
export declare const fetchMetaData: (locale: string) => Promise<{
    versionInfo: {
        majorVersion: number;
        minorVersion: number;
        patchVersion: number;
        buildStamp: any;
        applicationName: any;
    };
    userInfo: any;
    sitemap: any;
    notifications: any;
    translations: any;
}>;
export declare const fetchNotifications: (locale: string) => Promise<any>;
export declare const notificationMarkRead: (notificationId: string, locale: string) => Promise<boolean>;
export declare const notificationMarkAllRead: (locale: string) => Promise<boolean>;
export declare const notificationMarkUnread: (notificationId: string, locale: string) => Promise<boolean>;
export declare const notificationDelete: (notificationId: string, locale: string) => Promise<boolean>;
//# sourceMappingURL=metadata-service.d.ts.map