import axios from 'axios';
/**
 * List of pages where the chatbot should be activated
 */
export const CHATBOT_SUPPORTED_PAGES = [
    '@sage/xtrem-manufacturing/WorkOrder',
    '@sage/xtrem-master-data/Customer',
    '@sage/xtrem-master-data/Supplier',
    '@sage/xtrem-purchasing/PurchaseOrder',
    '@sage/xtrem-sales/SalesInvoice',
    '@sage/xtrem-sales/SalesOrder',
    '@sage/xtrem-show-case/ShowCaseProduct',
];
export const getAccessCode = async (loginServiceUrl, chatbotAccessCodeLifeTimeInMinutes) => {
    const response = await axios.get(`${loginServiceUrl}/copilot`, { withCredentials: true });
    if (!response.data?.accessCode) {
        // eslint-disable-next-line no-console
        console.warn('Invalid chatbot access code received.');
        // eslint-disable-next-line no-console
        console.warn(response.data);
        return null;
    }
    const accessCodeExpiration = Date.now() + chatbotAccessCodeLifeTimeInMinutes * 60 * 1000;
    return {
        code: response.data.accessCode,
        expiration: accessCodeExpiration,
    };
};
export const fetchAiToken = async () => {
    // TODO: do we need to cache this to minimize the number of requests?
    const response = await axios.post('/metadata', {
        query: `{
                serviceSettings {
                    copilot {
                        token
                        expiration
                        enabled
                    }
                }
              }`,
    });
    if (!response.data?.data?.serviceSettings?.copilot?.token) {
        // eslint-disable-next-line no-console
        console.warn('Invalid gms token received.');
        // eslint-disable-next-line no-console
        console.warn(response.data);
        return null;
    }
    return {
        token: response.data.data.serviceSettings.copilot.token,
        expiration: Number(response.data.data.serviceSettings.copilot.expiration),
        enabled: response.data.data.serviceSettings.copilot.enabled,
    };
};
export async function fetchChatbotConfiguration(loginServiceUrl, chatbotAccessCodeLifeTimeInMinutes = 60) {
    try {
        const aiToken = await fetchAiToken();
        if (!aiToken) {
            // eslint-disable-next-line no-console
            console.warn('Invalid chatbot token received.');
        }
        const accessCode = await getAccessCode(loginServiceUrl, chatbotAccessCodeLifeTimeInMinutes);
        if (!accessCode) {
            // eslint-disable-next-line no-console
            console.warn('Invalid chatbot access code received.');
            return null;
        }
        return {
            accessCode,
            aiToken,
            chatbotAccessCodeLifeTimeInMinutes,
        };
    }
    catch (err) {
        // eslint-disable-next-line no-console
        console.warn('Failed to fetch chatbot config');
        // eslint-disable-next-line no-console
        console.warn(err);
        return null;
    }
}
//# sourceMappingURL=chatbot-service.js.map