/**
 * List of pages where the chatbot should be activated
 */
export declare const CHATBOT_SUPPORTED_PAGES: string[];
export interface ChatbotConfiguration {
    aiToken: {
        token: string;
        expiration: number;
    } | null;
    accessCode: {
        code: string;
        expiration: number;
    } | null;
    chatbotAccessCodeLifeTimeInMinutes?: number;
}
export declare const getAccessCode: (loginServiceUrl: string, chatbotAccessCodeLifeTimeInMinutes: number) => Promise<{
    code: string;
    expiration: number;
} | null>;
export declare const fetchAiToken: () => Promise<{
    token: string;
    expiration: number;
    enabled: boolean;
} | null>;
export declare function fetchChatbotConfiguration(loginServiceUrl: string, chatbotAccessCodeLifeTimeInMinutes?: number): Promise<ChatbotConfiguration | null>;
//# sourceMappingURL=chatbot-service.d.ts.map