import { integration } from '@sage/xtrem-ui';
import * as React from 'react';
import type { UserDetails } from './service/auth-service';
import type { Dict, StandaloneConfig } from '@sage/xtrem-shared';
import './style.scss';
export interface XtremStandaloneProps {
    closeXtremChatbotOpen: () => void;
    config: StandaloneConfig | null;
    init: () => void;
    isExtraSmall: boolean;
    isNavigationOpen: boolean;
    isXtremChatbotOpen: boolean;
    loginService: string | null;
    onDirtyStatusChange: (isApplicationDirty: boolean, preNavigationConfirmation: () => Promise<void>) => void;
    onInternalNavigationChange: (path: string, doDirtyCheck: boolean) => Promise<void>;
    pageContext: integration.PageContext | null;
    path: string;
    setMenuItems: (menuItems: integration.Menu[]) => void;
    setPageContext: (pageContext: integration.PageContext | null) => void;
    setPageTitle: (newTitle: string) => void;
    translations: Dict<string>;
    updateNavStateBasedOnLocation: () => void;
    user: UserDetails | null;
}
export declare class XtremStandalone extends React.Component<XtremStandaloneProps, {
    removeXtremUi?: boolean;
}> {
    private intervalRef;
    private readonly iframeRef;
    private readonly xtremUiRef;
    private readonly appContext;
    private hasInitializedWebsocket;
    constructor(props: XtremStandaloneProps);
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    private readonly onInsightsFetched;
    private readonly checkAuthTokenState;
    private readonly onTelemetryEvent;
    private readonly onUserLogout;
    private readonly onUserUpdate;
    private readonly onUserChangeLocale;
    render(): React.JSX.Element;
}
export declare const ConnectedXtremStandaloneComponent: import("react-redux").ConnectedComponent<typeof XtremStandalone, {
    ref?: React.LegacyRef<XtremStandalone> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=index.d.ts.map