import { useEffect, useState } from 'react';
export const useLocalStorage = (key, initValue) => {
    const [value, setValue] = useState(() => {
        let currValue;
        try {
            currValue = JSON.parse(localStorage.getItem(key) || String(initValue));
        }
        catch (error) {
            currValue = initValue;
        }
        return currValue;
    });
    useEffect(() => {
        localStorage.setItem(key, JSON.stringify(value));
    }, [key, value]);
    return [value, setValue];
};
export const SKIP_EXTERNAL_LINK_CONFIRMATION_KEY = 'xe-notifications-skip-external-link-confirmation-key';
export const useSkipExternalLinkConfirmation = () => {
    const [value, setValue] = useState(() => {
        return isSkipExternalLinkConfirmation();
    });
    useEffect(() => {
        localStorage.setItem(SKIP_EXTERNAL_LINK_CONFIRMATION_KEY, JSON.stringify(value));
    }, [value]);
    return [value, setValue];
};
export const isSkipExternalLinkConfirmation = () => {
    let currValue;
    try {
        currValue = JSON.parse(localStorage.getItem(SKIP_EXTERNAL_LINK_CONFIRMATION_KEY) || String(false));
    }
    catch (error) {
        currValue = false;
    }
    return currValue;
};
//# sourceMappingURL=use-local-storage.js.map