import { localize } from '../../service/standalone-i18n-service';
import * as React from 'react';
import Icon from 'carbon-react/esm/components/icon';
import Link from 'carbon-react/esm/components/link';
import { getProfileMenuItems, ProfileSettingsTab } from './get-profile-menu-items';
import { ConnectedLanguageSelector } from './language-selector';
import { MyProfile } from './my-profile';
import './profile-settings.scss';
const renderProfileContent = (tab, user, translations, localeOnChange) => {
    switch (tab) {
        case ProfileSettingsTab.MyProfileTab:
            return (React.createElement("div", { className: "xe-profile-my-profile-content" },
                React.createElement(MyProfile, { user: user, translations: translations })));
        case ProfileSettingsTab.LanguageTab:
            return (React.createElement("div", { className: "xe-profile-language-content" },
                React.createElement(ConnectedLanguageSelector, { user: user, translations: translations, localeOnChange: localeOnChange })));
        default:
            return null;
    }
};
export function ProfileSettingsPanel(props) {
    const [currentTab, setTab] = React.useState(ProfileSettingsTab.MyProfileTab);
    return (React.createElement("div", { className: "xe-profile-container" },
        React.createElement("div", { className: "xe-profile-header" },
            React.createElement("span", null, localize('@sage/xtrem-standalone/personal-settings', 'Personal settings', {}, props.translations, props.user?.locale ?? undefined))),
        React.createElement("div", { className: "xe-profile-body" },
            React.createElement("div", { className: "xe-profile-menu" },
                React.createElement("div", { className: "xe-profile-menu-items-container" }, getProfileMenuItems(props.user, props.translations).map(item => (React.createElement("button", { type: "button", key: item.key, onClick: () => setTab(item.key), className: item.key === currentTab
                        ? 'xe-profile-menu-item xe-profile-menu-item-selected'
                        : 'xe-profile-menu-item' },
                    React.createElement("span", null, item.text))))),
                React.createElement("div", { className: "xe-profile-menu-logout" },
                    React.createElement(Icon, { color: "#FFFF", type: "logout" }),
                    React.createElement("a", { "data-component": "link", href: `${props.loginService}/logout?fromUrl=${document.location.href}`, className: "xe-profile-menu-logout-text" }, localize('@sage/xtrem-standalone/logout', 'Logout', {}, props.translations, props.user?.locale ?? undefined)))),
            React.createElement("div", { className: "xe-profile-content" },
                renderProfileContent(currentTab, props.user, props.translations, props.localeOnChange),
                React.createElement("div", { className: "xe-profile-links" },
                    React.createElement("div", { className: "xe-profile-menu-privacy-preferences-link" },
                        React.createElement(Link, { href: props.tenantItem.oneTrustMagicLink }, localize('@sage/xtrem-standalone/privacy-preferences', 'Privacy Preferences', {}, props.translations, props.user?.locale ?? undefined))))))));
}
ProfileSettingsPanel.displayName = 'ProfileSettingsPanel';
//# sourceMappingURL=index.js.map