import Sidebar from 'carbon-react/esm/components/sidebar/sidebar.component';
import React from 'react';
import { connect } from 'react-redux';
import { localize } from '../../service/standalone-i18n-service';
import * as actions from '../../standalone-redux/actions';
import './notification-center.scss';
import { NotificationCenterHeader } from './notification-center-header';
import { ConnectedNotificationCenterItem } from './notification-center-item';
import { EmptyNotification } from './empty-notification';
export function NotificationCenter(props) {
    const onCloseSidebar = () => {
        props.setNotificationCenterOpen(false);
    };
    return (React.createElement(Sidebar, { "data-element": "notification-center", header: React.createElement(NotificationCenterHeader, { locale: props.locale, translations: props.translations }), open: props.open, onCancel: onCloseSidebar },
        React.createElement("div", { className: "xe-notification-center" },
            React.createElement("div", { "data-testid": "xe-notification-content", className: "xe-notification-content" }, props.notifications.length > 0 ? (props.notifications.map(notification => (React.createElement(ConnectedNotificationCenterItem, { key: notification._id, id: notification._id })))) : (React.createElement("div", { className: "xe-notification-empty" },
                React.createElement(EmptyNotification, null),
                React.createElement("span", { className: "xe-notification-empty-title" }, localize('@sage/xtrem-standalone/no-notification-title', "You're up to date.", {}, props.translations, props.locale)),
                React.createElement("span", { className: "xe-notification-empty-description" }, localize('@sage/xtrem-standalone/no-notification-description', "You'll get a notification when there's something new.", {}, props.translations, props.locale))))))));
}
const mapStateToProps = (state, ownProps) => ({
    ...ownProps,
    locale: state.user?.locale || 'en-US',
    notifications: state.notifications,
    markAllNotificationsAsRead: actions.actionStub,
    setNotificationCenterOpen: actions.actionStub,
    translations: state.translations,
});
const mapDispatchToProps = (dispatch) => ({
    markAllNotificationsAsReaad: () => dispatch(actions.markAllNotificationsAsRead()),
    setNotificationCenterOpen: (isOpen) => dispatch(actions.setNotificationCenterOpen(isOpen)),
});
// tslint:disable-next-line:variable-name
export const ConnectedNotificationCenter = connect(mapStateToProps, mapDispatchToProps)(NotificationCenter);
//# sourceMappingURL=notification-center.js.map