import Button from 'carbon-react/esm/components/button';
import { Checkbox } from 'carbon-react/esm/components/checkbox';
import Dialog from 'carbon-react/esm/components/dialog';
import Form from 'carbon-react/esm/components/form';
import Typography from 'carbon-react/esm/components/typography';
import React, { useState } from 'react';
import { localize } from '../../service/standalone-i18n-service';
import './external-link-confirmation-dialog.scss';
export function ExternalLinkConfirmationDialog({ isOpen, locale, onCancel, onConfirm, translations, }) {
    const [isSkipConfirmationChecked, setSkipConfirmationChecked] = useState(false);
    const onChangeSkipConfirmationCheckbox = (event) => {
        setSkipConfirmationChecked(event.target.checked);
    };
    const onCancelButtonClick = () => {
        onCancel(isSkipConfirmationChecked);
    };
    const onConfirmButtonClick = () => {
        onConfirm(isSkipConfirmationChecked);
    };
    return (React.createElement(Dialog, { "data-element": "xe-external-link-confirmation-dialog", "data-testid": "xe-external-link-confirmation-dialog", open: isOpen, subtitle: localize('@sage/xtrem-standalone/external-link-confirmation-dialog-subtitle', 'Proceed with caution.', {}, translations, locale), title: localize('@sage/xtrem-standalone/external-link-confirmation-dialog-title', 'External link', {}, translations, locale) },
        React.createElement(Form, { leftSideButtons: React.createElement("div", { className: "xe-external-link-confirmation-dialog-footer" },
                React.createElement("div", { className: "xe-external-link-confirmation-dialog-skip-confirmation" },
                    React.createElement(Checkbox, { "data-testid": "xe-external-link-confirmation-dialog-skip-confirmation-checkbox", label: localize('@sage/xtrem-standalone/external-link-confirmation-dialog-skip-confirmation-label', `Don't show this message again`, {}, translations, locale), name: "xe-external-link-confirmation-dialog-skip-confirmation-checkbox", onChange: onChangeSkipConfirmationCheckbox })),
                React.createElement("div", { className: "xe-external-link-confirmation-dialog-actions" },
                    React.createElement("div", { className: "xe-external-link-confirmation-dialog-action-cancel" },
                        React.createElement(Button, { buttonType: "secondary", "data-testid": "xe-external-link-confirmation-dialog-action-cancel-button", name: "xe-external-link-confirmation-dialog-action-cancel-button", onClick: onCancelButtonClick }, localize('@sage/xtrem-standalone/external-link-confirmation-dialog-action-cancel', 'Cancel', {}, translations, locale))),
                    React.createElement("div", { className: "xe-external-link-confirmation-dialog-action-confirm" },
                        React.createElement(Button, { buttonType: "secondary", "data-testid": "xe-external-link-confirmation-dialog-action-confirm-button", name: "xe-external-link-confirmation-dialog-action-confirm-button", onClick: onConfirmButtonClick }, localize('@sage/xtrem-standalone/external-link-confirmation-dialog-action-confirm', 'Continue', {}, translations, locale))))), stickyFooter: true },
            React.createElement(Typography, null,
                React.createElement("span", { "data-testid": "xe-external-link-confirmation-dialog-content-line-1" }, localize('@sage/xtrem-standalone/external-link-confirmation-dialog-content-line-1', 'This link takes you to an external website and opens in a new browser tab.', {}, translations, locale)),
                React.createElement("br", null),
                React.createElement("span", { "data-testid": "xe-external-link-confirmation-dialog-content-line-2" }, localize('@sage/xtrem-standalone/external-link-confirmation-dialog-content-line-2', 'Sage is not responsible for the content or privacy policies on that page.', {}, translations, locale))))));
}
//# sourceMappingURL=exterrnal-link-confirmation-dialog.js.map