import * as React from 'react';
import { useSelector } from 'react-redux';
import './chatbot.scss';
import { GmsChatWindow } from '@sageai/gms-chat-ui-react';
import { date } from '@sage/xtrem-date-time';
export function Chatbot() {
    const userCurrentDate = React.useMemo(() => date.today(Intl.DateTimeFormat().resolvedOptions().timeZone).toString(), []);
    const chatbotConfig = useSelector(s => s.chatbotConfig);
    const chatbotBackendUrl = useSelector(s => s.config?.chatbotBackendUrl || null);
    const chatbotGmsClient = useSelector(s => s.config?.chatbotGmsClient ?? 'sdmo_v1');
    const app = useSelector(s => s.config?.app ?? 'sdmo');
    const user = useSelector(state => state.user);
    const pageContext = useSelector(state => state.pageContext);
    if (!chatbotConfig || !chatbotBackendUrl || !user?.uuid || !user?.locale) {
        return null;
    }
    const authToken = chatbotConfig.aiToken?.token ?? '';
    const accessCode = chatbotConfig.accessCode?.code;
    return (React.createElement(GmsChatWindow, { "data-testid": "gms-chat-window", backendUrl: chatbotBackendUrl, enableInsights: true, enableChat: true, authToken: authToken, userId: user.uuid, gmsClient: chatbotGmsClient, showSidebar: false, showSuggestions: false, showChatInput: false, showConversationStarter: true, fetchHistory: true, showHeading: true, roundedCorners: true, initialDisplayState: "hidden", disableShadowDom: true, chatContext: {
            tenantId: user?.tenantId ?? undefined, // (string) the tenant id of the user
            userLocale: user?.locale ?? undefined, // (string) the locale of the user
            userCurrentDate, // (string) the current date in the user's timezone
            nodeName: pageContext?.nodeName, // (string) the name of the current node
            recordFilter: pageContext?.recordFilter, // (string) the filter to get the current record
            screenId: pageContext?.screenId, // (string) the id of the current screen
            screenTitle: pageContext?.screenTitle, // (string) the title of the current screen
            app: app ?? undefined, // (string) the app name that is used to identify the current app
            apiAccessCode: accessCode ?? undefined, // (string) the access code that is used to authenticate the ai backend service
        } }));
}
//# sourceMappingURL=chatbot.js.map