import * as React from 'react';
import configureMockStore from 'redux-mock-store';
import reduxThunk from 'redux-thunk';
import * as actions from '../standalone-redux/actions';
jest.mock('@sage/xtrem-ui', () => ({ integration: { XtremUiIndex: jest.fn(() => React.createElement("div", null, "Xtrem UI Placeholder")) } }));
const mockReduxActions = () => {
    return Object.keys(actions).map(actionKey => jest
        .spyOn(actions, actionKey)
        .mockImplementation(() => ({ type: 'TEST_REDUX_ACTION', value: undefined })));
};
export const getMockState = (partialState = {}) => ({
    browser: { is: { xs: false } },
    chatbotConfig: null,
    config: null,
    isApplicationDirty: false,
    isChatbotOpen: false,
    isNavigationOpen: false,
    isNotificationCenterOpen: false,
    isXtremChatbotAvailable: false,
    isXtremChatbotOpen: false,
    loginService: null,
    menuItems: [],
    notifications: [],
    pageContext: null,
    pageTitle: null,
    path: '',
    preNavigationConfirmation: () => Promise.resolve(),
    sitemap: [],
    tenantsList: { oneTrustMagicLink: '', tenantList: [] },
    translations: {},
    user: null,
    ...partialState,
});
export const getMockStore = (storeState = getMockState(), shouldMockReduxActions = true) => {
    const mockStoreCreator = configureMockStore([reduxThunk]);
    if (shouldMockReduxActions) {
        mockReduxActions();
    }
    return mockStoreCreator(storeState);
};
//# sourceMappingURL=test-utils.js.map