// eslint.config.mjs (ESLint v9+)
import { defineConfig, globalIgnores } from 'eslint/config';
import globals from 'globals';
import baseConfig from '../../eslint-base.config.mjs';

export default defineConfig([
    globalIgnores(['build/**', 'tmp/**', 'node_modules/**', '**/coverage', '**/i18n/*.json']),
    {
        languageOptions: {
            parserOptions: {
                parser: '@typescript-eslint/parser',
                projectService: true,
                tsconfigRootDir: import.meta.dirname,
                project: ['tsconfig.json'],
                extraFileExtensions: ['.json'],
            },
        },
    },
    ...baseConfig,
    {
        files: ['**/*.js'],
        rules: {
            '@typescript-eslint/no-require-imports': 'off',
        },
    },
    {
        files: ['**/*.ts'],
        rules: {
            // To review: ESLint V9 migration (all the following are temporarily disabled)
            '@stylistic/quotes': 'off',
            '@typescript-eslint/no-duplicate-type-constituents': 'off',
            '@typescript-eslint/no-non-null-asserted-optional-chain': 'off',
            '@typescript-eslint/no-require-imports': 'off',
            '@typescript-eslint/no-unnecessary-type-assertion': 'off',
            '@typescript-eslint/no-unsafe-enum-comparison': 'off',
            'import/no-import-module-exports': 'off',
            'react-hooks/rules-of-hooks': 'off',
        },
    },
    // config envs
    {
        languageOptions: {
            globals: { ...globals.browser, ...globals.node },
        },
    },
]);
