// From file: @sage/xtrem-date-time/build/index.d.ts
declare module '@sage/xtrem-date-time/index' {
	export * from '@sage/xtrem-date-time/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/walkformat.d.ts
declare module '@sage/xtrem-date-time/lib/walkformat' {
	export function walkFormat(format: string, map: {
	    [key: string]: (arg: any) => void;
	}): void;
	//# sourceMappingURL=walkformat.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/uuid.d.ts
declare module '@sage/xtrem-date-time/lib/uuid' {
	export const $exported = true;
	export function generate(sep?: string): string;
	export function fromBytes(bytes: Uint8Array | number[]): string;
	export function toBytes(str: string): number[];
	export function fromString32(str: string): string;
	export function toString32(uuid: string): string;
	//# sourceMappingURL=uuid.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/utils.d.ts
declare module '@sage/xtrem-date-time/lib/utils' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import type { DatePropertyValue, DateTimePropertyValue } from '@sage/xtrem-date-time/lib/types';
	export function pad2(val: number): string;
	export function pad3(val: number): string;
	/**
	 * All i18n keys are individual records. Some of these records needs to function in a group i.e. days of the week and months.
	 * @param baseResource string[] - see datetime/baseResource.ts
	 * @param data object | any[] - default is any. Data for i18n value handlebars
	 * @param i18nKey string - example: @sage/xtrem-date-time/datetime__abbreviatedDayName - NB! without the index. see datetime/i18n/en-US.json
	 * @param locale LocalizeLocale - default is base
	 * @returns string[] of localized semantic values
	 */
	export function localizedGroup(baseResource: readonly string[], i18nKey: string, data?: object | any[], locale?: LocalizeLocale): string[];
	export const isStringDate: (value: any) => boolean;
	export function datePropertyValueToDateString(value: null | undefined, keepTime?: boolean): null;
	export function datePropertyValueToDateString(value: DatePropertyValue | DateTimePropertyValue, keepTime?: boolean): string;
	export function datePropertyValueToDateString(value: DatePropertyValue | DateTimePropertyValue | null | undefined, keepTime?: boolean): string | null;
	export function isValidDatePropertyValue(value: DatePropertyValue): boolean;
	//# sourceMappingURL=utils.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/types.d.ts
declare module '@sage/xtrem-date-time/lib/types' {
	import type { DateValue } from '@sage/xtrem-date-time/lib/date';
	import type { Datetime } from '@sage/xtrem-date-time/lib/datetime';
	export type DatePropertyValue = Date | string | DateValue;
	export type DateTimePropertyValue = Date | string | Datetime;
	//# sourceMappingURL=types.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/type-constraints.d.ts
declare module '@sage/xtrem-date-time/lib/type-constraints' {
	export interface EnumValue {
	    $value: number;
	}
	export interface TypeConstraints {
	    $isMandatory?: boolean;
	    $isNullable?: boolean;
	    $minimum?: number;
	    $maximum?: number;
	    $minimumCanEqual?: boolean;
	    $maximumCanEqual?: boolean;
	    $divisibleBy?: number;
	    $enum?: EnumValue[];
	    $minLength?: number;
	    $maxLength?: number;
	    $pattern?: string;
	    $patternModifiers?: string;
	    $patternMessage?: string;
	}
	//# sourceMappingURL=type-constraints.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/time.d.ts
declare module '@sage/xtrem-date-time/lib/time' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	export type TimeDiff = {
	    hours?: number;
	    minutes?: number;
	    seconds?: number;
	    millis?: number;
	};
	export class Time {
	    private readonly _value;
	    constructor(value: number);
	    get constructorName(): string;
	    get hour(): number;
	    get minute(): number;
	    get second(): number;
	    get value(): number;
	    valueOf(): string;
	    toJSON(): string;
	    compare(time: Time): number;
	    equals(time: Time): boolean;
	    isBetween(begin: Time, end: Time): boolean;
	    begOfDay(): Time;
	    endOfDay(): Time;
	    begOfHour(): Time;
	    endOfHour(): Time;
	    begOfMinute(): Time;
	    endOfMinute(): Time;
	    toString(): string;
	    format(locale?: LocalizeLocale, format?: string): string;
	    secondsDiff(t: Time): number;
	    addHours(hours: number): Time;
	    addMinutes(minutes: number): Time;
	    addSeconds(seconds: number): Time;
	    add(delta: TimeDiff): Time;
	    isNull(): boolean;
	    static make(hour: number, minute: number, second: number): Time;
	    static fromSeconds(seconds: number): Time;
	    static fromJsDate(js: Date, timeZone?: string): Time;
	    static now(timeZone?: string): Time;
	    static parse(str: string, locale?: LocalizeLocale, format?: string): Time;
	    static amDesignator(locale?: LocalizeLocale): string;
	    static pmDesignator(locale?: LocalizeLocale): string;
	    static isTime(obj: any): boolean;
	}
	export const make: typeof Time.make;
	export const fromSeconds: typeof Time.fromSeconds;
	export const fromJsDate: typeof Time.fromJsDate;
	export const now: typeof Time.now;
	export const parse: typeof Time.parse;
	export const amDesignator: typeof Time.amDesignator;
	export const pmDesignator: typeof Time.pmDesignator;
	export const isTime: typeof Time.isTime;
	//# sourceMappingURL=time.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/time-zone.d.ts
declare module '@sage/xtrem-date-time/lib/time-zone' {
	export class TimeZone {
	    static getAvailableTimeZones(): string[];
	}
	//# sourceMappingURL=time-zone.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/range.d.ts
declare module '@sage/xtrem-date-time/lib/range' {
	export abstract class Range<T> {
	    start: T | null;
	    end: T | null;
	    excludesStart: boolean;
	    excludesEnd: boolean;
	    includedStart: T | null;
	    excludedStart: T | null;
	    includedEnd: T | null;
	    excludedEnd: T | null;
	    constructor(start: T | null, end: T | null, excludesStart?: boolean, excludesEnd?: boolean);
	    abstract get constructorName(): string;
	    validateRange(): void;
	    abstract incrementsByRangeUnit(elm: T, step?: number): T;
	    abstract getBoundValue(elm: T | null): number | null;
	    abstract getStringBoundValue(elm: T | null): string;
	    includes(elmToCompareWith: T | null): boolean;
	    equals(rangeToCompareWith: Range<T> | null): boolean;
	    toString(): string;
	    toJSON(): string;
	}
	//# sourceMappingURL=range.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/parse.d.ts
declare module '@sage/xtrem-date-time/lib/parse' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	interface DateTimeObject {
	    day: number;
	    month: number;
	    year: number;
	    hour: number;
	    minute: number;
	    second: number;
	    millis: number;
	    timeMode: number;
	    abbrTimeMode: number;
	    timeModes: string[];
	    abbrTimeModes: string[];
	    tzOffset?: number;
	    timeZone?: string;
	}
	export function createDateTimeObj(timeModes?: string[], abbrTimeModes?: string[], timeZone?: string | undefined): DateTimeObject;
	export function parseDateTime(str: string, format: string, timeObj: DateTimeObject, locale?: LocalizeLocale): void;
	export {};
	//# sourceMappingURL=parse.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/localize.d.ts
declare module '@sage/xtrem-date-time/lib/localize' {
	import { LocalizeFunction } from '@sage/xtrem-shared';
	export const localizedText: LocalizeFunction;
	export const setLocalizeImplementation: (localizeImpl: LocalizeFunction) => void;
	//# sourceMappingURL=localize.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/integer-range.d.ts
declare module '@sage/xtrem-date-time/lib/integer-range' {
	import { Range } from '@sage/xtrem-date-time/lib/range';
	export type integer = number;
	export class IntegerRange extends Range<integer> {
	    static parse: typeof parse;
	    static isIntegerRange: typeof isIntegerRange;
	    static isValidIntegerRangeString: typeof isValidIntegerRangeString;
	    static make: typeof make;
	    get constructorName(): string;
	}
	export function parse(str: string): IntegerRange;
	export function isIntegerRange(obj: any): obj is Range<integer>;
	function isValidIntegerRangeString(str: string): boolean;
	export function make(start: integer | null, end: integer | null, excludesStart?: boolean, excludesEnd?: boolean): IntegerRange;
	export {};
	//# sourceMappingURL=integer-range.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/index.d.ts
declare module '@sage/xtrem-date-time/lib/index' {
	import * as date from '@sage/xtrem-date-time/lib/date';
	import * as dateRange from '@sage/xtrem-date-time/lib/date-range';
	import * as datetime from '@sage/xtrem-date-time/lib/datetime';
	import * as datetimeRange from '@sage/xtrem-date-time/lib/datetime-range';
	import * as decimalRange from '@sage/xtrem-date-time/lib/decimal-range';
	import * as integerRange from '@sage/xtrem-date-time/lib/integer-range';
	import * as time from '@sage/xtrem-date-time/lib/time';
	import * as uuid from '@sage/xtrem-date-time/lib/uuid';
	export { DateDiff, DateValue, WeekDay } from '@sage/xtrem-date-time/lib/date';
	export { DateRange, DateRangeType, getDateRange } from '@sage/xtrem-date-time/lib/date-range';
	export { Datetime, DatetimeDiff } from '@sage/xtrem-date-time/lib/datetime';
	export { DatetimeRange } from '@sage/xtrem-date-time/lib/datetime-range';
	export { DecimalRange } from '@sage/xtrem-date-time/lib/decimal-range';
	export * from '@sage/xtrem-date-time/lib/formatting-utils';
	export { IntegerRange } from '@sage/xtrem-date-time/lib/integer-range';
	export { setLocalizeImplementation } from '@sage/xtrem-date-time/lib/localize';
	export { Range } from '@sage/xtrem-date-time/lib/range';
	export { Time, TimeDiff } from '@sage/xtrem-date-time/lib/time';
	export { TimeZone } from '@sage/xtrem-date-time/lib/time-zone';
	export { EnumValue, TypeConstraints } from '@sage/xtrem-date-time/lib/type-constraints';
	export { datePropertyValueToDateString, isStringDate, isValidDatePropertyValue } from '@sage/xtrem-date-time/lib/utils';
	export { date, dateRange, datetime, datetimeRange, decimalRange, integerRange, time, uuid };
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/formatting-utils.d.ts
declare module '@sage/xtrem-date-time/lib/formatting-utils' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import { Datetime, Time } from '@sage/xtrem-date-time/lib/index';
	import { DateValue } from '@sage/xtrem-date-time/lib/date';
	export type DatePresetFormat = 'FullDate' | 'LongMonth' | 'LongMonthYear' | 'MonthDay' | 'MonthYear' | 'LongMonthDayYear';
	type FormableDate = Date | string | DateValue | Datetime;
	export const formatDateToCurrentLocale: (date: FormableDate, locale?: LocalizeLocale, fmt?: DatePresetFormat) => string;
	type FormableTime = Date | string | Time | Datetime;
	export const formatTimeToLocale: (time: FormableTime, locale?: LocalizeLocale) => string;
	export const parseLocalizedDate: (date: string, locale?: LocalizeLocale, fmt?: DatePresetFormat) => DateValue;
	export const parseIsoDate: (date: string, locale?: LocalizeLocale) => DateValue;
	export const isValidLocalizedDate: (date: string, locale?: LocalizeLocale, fmt?: DatePresetFormat) => boolean;
	export const isValidIsoDate: (date: string, locale?: LocalizeLocale) => boolean;
	export {};
	//# sourceMappingURL=formatting-utils.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/decimal-range.d.ts
declare module '@sage/xtrem-date-time/lib/decimal-range' {
	import { Decimal } from '@sage/xtrem-decimal';
	import { Range } from '@sage/xtrem-date-time/lib/range';
	export class DecimalRange extends Range<Decimal> {
	    static parse: typeof parse;
	    static isDecimalRange: typeof isDecimalRange;
	    static isValidDecimalRangeString: typeof isValidDecimalRangeString;
	    static make: typeof make;
	    get constructorName(): string;
	}
	export function parse(str: string): DecimalRange;
	export function isDecimalRange(obj: any): obj is Range<Decimal>;
	function isValidDecimalRangeString(str: string): boolean;
	export function make(start: Decimal | string | number | null, end: Decimal | string | number | null, excludesStart?: boolean, excludesEnd?: boolean): DecimalRange;
	export {};
	//# sourceMappingURL=decimal-range.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/datetime.d.ts
declare module '@sage/xtrem-date-time/lib/datetime' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import * as date from '@sage/xtrem-date-time/lib/date';
	import { integer } from '@sage/xtrem-date-time/lib/date';
	import * as time from '@sage/xtrem-date-time/lib/time';
	export type DatetimeDiff = date.DateDiff & time.TimeDiff;
	/**
	 * A `Datetime` represents a specific point in time.
	 *
	 * The main differences with JavaScript `Date` are:
	 *
	 * - `Datetime` is immutable.
	 * - The `month` property takes values between 1 and 12, not 0 and 11.
	 */
	export class Datetime {
	    /** Internal value: GMT millis since epoch (Jan 1st, 1970) */
	    private readonly _value;
	    /** The time zone used to format the value */
	    private readonly _timeZone;
	    /**
	     * Internal cache of the UTC values (year, month, day, hour, minute, second).
	     * Packed int with year, month, day, hour, minute, second.
	     * See Datetime.pack for details.
	     */
	    private _utcValues;
	    /**
	     * Internal cache of the time zone field values (year, month, day, hour, minute, second).
	     * Packed int with year, month, day, hour, minute, second.
	     * See Datetime.pack for details.
	     */
	    private _tzValues;
	    private constructor();
	    /**
	     * Pack datetime components into an int.
	     * JS int is 53 bits, so we can pack year, month, day, hour, minute, second on powers of 10 without overflow
	     * The millisecond part is not included as it is independent from UTC / time zone and can be obtained from #value.
	     */
	    private static pack;
	    private get utcValue();
	    private get tzValue();
	    get constructorName(): string;
	    get timeZone(): string | undefined;
	    /** The date (only year, month, day). */
	    get date(): date.DateValue;
	    /** The time (only hour, minute, second, millisecond). */
	    get time(): time.Time;
	    /** The year, between 0 and 9999. */
	    get year(): integer;
	    /** The month, between 1 and 12. */
	    get month(): integer;
	    /** The day, between 1 and 31. */
	    get day(): integer;
	    /** The week day, between 0 (Sunday) and 6 (Saturday). */
	    get weekDay(): date.WeekDay;
	    /** The day of the year, between 1 and 366. */
	    get yearDay(): integer;
	    /** The hour, between 0 and 23. */
	    get hour(): integer;
	    /** The minute, between 0 and 59. */
	    get minute(): integer;
	    /** The second, between 0 and 59. */
	    get second(): integer;
	    /** The millisecond, between 0 and 999. */
	    get millisecond(): integer;
	    get utcDate(): date.DateValue;
	    get utcTime(): time.Time;
	    get utcYear(): number;
	    get utcMonth(): number;
	    get utcDay(): number;
	    get utcWeekDay(): date.WeekDay;
	    get utcYearDay(): number;
	    get utcHour(): number;
	    get utcMinute(): number;
	    get utcSecond(): number;
	    get utcMillisecond(): number;
	    get value(): number;
	    compare(dt: Datetime): number;
	    equals(dt: Datetime): boolean;
	    isBetween(begin: Datetime, end: Datetime): boolean;
	    addYears(years: number): Datetime;
	    addMonths(months: number): Datetime;
	    addWeeks(weeks: number): Datetime;
	    addDays(days: number): Datetime;
	    addHours(hours: number): Datetime;
	    addMinutes(minutes: number): Datetime;
	    addSeconds(seconds: number): Datetime;
	    addMilliseconds(millis: number): Datetime;
	    addDayFractions(fraction: number): Datetime;
	    millisDiff(dt: Datetime): number;
	    withoutMillis(): Datetime;
	    inTimeZone(timeZone: string | undefined): Datetime;
	    add(delta: DatetimeDiff): Datetime;
	    toString(): string;
	    static formatDirectiveError(format: string, letter: string, locale: LocalizeLocale, repeat: number): Error;
	    format(locale: LocalizeLocale | undefined, format: string): string;
	    toJsDate(): Date;
	    toJSON(): string;
	    withoutTimezoneOffset(): Datetime;
	    isNull(): boolean;
	    private static parseIso;
	    static now(withMillis?: boolean, timeZone?: string): Datetime;
	    static parse(str: string, locale?: LocalizeLocale, format?: string, timeZone?: string): Datetime;
	    static fromJsDate(jsDate: Date, timeZone?: string): Datetime;
	    static fromValue(value: number, timeZone?: string): Datetime;
	    private static validateDateValues;
	    static make(year: number, month: number, day: number, hour?: number, minute?: number, second?: number, millis?: number, timeZone?: string): Datetime;
	    static makeUtc(year: number, month: number, day: number, hour?: number, minute?: number, second?: number, millis?: number): Datetime;
	    /**
	     * RegExp to test a string for an ISO 8601 Date spec
	     *  YYYY
	     *  YYYY-MM
	     *  YYYY-MM-DD
	     *  YYYY-MM-DD[T| ]HH:mmTZD
	     *  YYYY-MM-DD[T| ]HH:mm:ssTZD
	     *  YYYY-MM-DD[T| ]HH:mm:ss.sTZD
	     * @see: https://www.w3.org/TR/NOTE-datetime
	     */
	    static isoDatetimeRegexISO8601: RegExp;
	    static isDatetime(obj: any): obj is Datetime;
	}
	export const sunday = 0;
	export const monday = 1;
	export const tuesday = 2;
	export const wednesday = 3;
	export const thursday = 4;
	export const friday = 5;
	export const saturday = 6;
	export function overrideNow(str: string | null): void;
	export const now: typeof Datetime.now;
	export const parse: typeof Datetime.parse;
	export const fromJsDate: typeof Datetime.fromJsDate;
	export const fromValue: typeof Datetime.fromValue;
	export const make: typeof Datetime.make;
	export const makeUtc: typeof Datetime.makeUtc;
	export const isDatetime: typeof Datetime.isDatetime;
	//# sourceMappingURL=datetime.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/datetime-range.d.ts
declare module '@sage/xtrem-date-time/lib/datetime-range' {
	import { Datetime } from '@sage/xtrem-date-time/lib/datetime';
	import { Range } from '@sage/xtrem-date-time/lib/range';
	export class DatetimeRange extends Range<Datetime> {
	    get constructorName(): string;
	    get durationInMilliseconds(): number;
	    static parse(str: string, timeZone?: string): DatetimeRange;
	    static isDatetimeRange(obj: any): obj is Range<Datetime>;
	    static make(start: Datetime | null, end: Datetime | null, excludesStart?: boolean, excludesEnd?: boolean): DatetimeRange;
	}
	export const parse: typeof DatetimeRange.parse;
	export const isDatetimeRange: typeof DatetimeRange.isDatetimeRange;
	export const make: typeof DatetimeRange.make;
	//# sourceMappingURL=datetime-range.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/date.d.ts
declare module '@sage/xtrem-date-time/lib/date' {
	/** @packageDocumentation @module date */
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import * as datetime from '@sage/xtrem-date-time/lib/datetime';
	import * as time from '@sage/xtrem-date-time/lib/time';
	/** Integer type, to distinguish integers in the API documentation */
	export type integer = number;
	export const abbreviatedMonthNames: string[];
	export const monthNames: string[];
	/** Day of the week */
	export enum WeekDay {
	    sunday = 0,
	    monday = 1,
	    tuesday = 2,
	    wednesday = 3,
	    thursday = 4,
	    friday = 5,
	    saturday = 6
	}
	export const abbreviatedDayNames: string[];
	export type WeekDayName = (typeof dayNames)[number];
	export const dayNames: readonly ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
	export function isLeap(year: number): boolean;
	export function daysInMonth(year: number, month: number): number;
	export type DateDiff = {
	    years?: number;
	    months?: number;
	    weeks?: number;
	    days?: number;
	};
	/**
	 * A `DateValue` represents a date.
	 *
	 * This class is called `DateValue` rather than Date to avoid confusions with JavaScript's built-in `Date` class.
	 *
	 * The main differences with JavaScript `Date` are:
	 *
	 * - `DateValue` is a pure date, without any time nor timezone information. Only year, month and day.
	 * - `DateValue` is immutable.
	 * - The `month` property takes values between 1 and 12, not 0 and 11.
	 *
	 * The API uses a simple chaining style. For example:
	 *
	 * ```ts
	 * // the current date
	 * const today = DateValue.today();
	 * // the end of this month, as another date
	 * const endOfThisMonth = today.endOfThisMonth();
	 * // the week day of the first day of next month
	 * const nextMonthWeekStart = today.begOfMonth().addMonth(1).weekDay;
	 * ```
	 */
	export class DateValue {
	    /**
	     * The internal value for the date, as a number YYYYMMDD
	     * This is *not* the number of milliseconds since 1970, but the year, month and day packed into a single number.
	     */
	    private readonly _value;
	    constructor(value: number);
	    get constructorName(): string;
	    /**
	     * The date's internal value.
	     *
	     * Note: this is *not* the UNIX timestamp but the year, month and day packed into a single number,
	     * for example 20200514 for 2020-05-14
	     */
	    get value(): integer;
	    /** Number of seconds since 1970-01-01 */
	    get epoch(): integer;
	    /** The year, between 0 and 9999. */
	    get year(): integer;
	    /** The month, between 1 and 12. */
	    get month(): integer;
	    /** The day of the month, between 1 and 31. */
	    get day(): integer;
	    /** The day of the week, between 0 (Sunday) and 6 (Saturday).  */
	    get weekDay(): WeekDay;
	    /** The day of the year, between 1 and 366. */
	    get yearDay(): integer;
	    /**
	     * The week number, between 1 and 53, as defined by [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Week_dates).
	     *
	     * Week 1 is the beginning of the week that contains January 4th.
	     */
	    get week(): integer;
	    valueOf(): string;
	    /**
	     * Compares two dates.
	     *
	     * `date1.compare(date2)` returns a positive integer if `date1 > date2`,
	     * a negative integer if `date1 < date2`, and 0 if the dates are equal.
	     */
	    compare(date: DateValue): integer;
	    /** Tests date equality */
	    equals(date: DateValue): boolean;
	    /** Is the date between `begin` and `end`? (inclusive) */
	    isBetween(begin: DateValue, end: DateValue): boolean;
	    /** Is the date in a leap year? */
	    isLeapYear(): boolean;
	    /** Is the date a work day? (between Monday and Friday) */
	    isWorkDay(): boolean;
	    /** The number of days in the date's month, between 28 and 31. */
	    daysInMonth(): number;
	    /** The 1st of January of the date's year. */
	    begOfYear(): DateValue;
	    /** The 31st of December of the date's year. */
	    endOfYear(): DateValue;
	    /** The first day of the date's quarter. */
	    begOfQuarter(): DateValue;
	    /** The last day of the date's quarter. */
	    endOfQuarter(): DateValue;
	    /** The first day of the date's month. */
	    begOfMonth(): DateValue;
	    /** The last day of the date's month. */
	    endOfMonth(): DateValue;
	    /** Date for a given day in the same month as this date. */
	    sameMonth(day: number): DateValue;
	    /** The last occurence of a given day of the month before this date. */
	    pastDay(day: number, includeThis?: boolean): DateValue;
	    /** The next occurence of a given day of the month after this date. */
	    futureDay(day: number, includeThis?: boolean): DateValue;
	    /** The last occurence of the same day in a given month before this date. */
	    pastMonth(month: number, includeThis?: boolean): DateValue;
	    /** The next occurence of the same day in a given month after this date. */
	    futureMonth(month: number, includeThis?: boolean): DateValue;
	    /** The beginning of the week which contains this date. */
	    begOfWeek(startDay?: WeekDay): DateValue;
	    /** The end of the week which contains this date. */
	    endOfWeek(startDay?: WeekDay): DateValue;
	    /** The requested week day in the same week as this date. */
	    sameWeek(weekDay: WeekDay, startDay?: WeekDay): DateValue;
	    /** The last requested week day before this date. */
	    pastWeekDay(weekDay: WeekDay, includeThis?: boolean): DateValue;
	    /** The next requested week day after this date. */
	    futureWeekDay(weekDay: WeekDay, includeThis?: boolean): DateValue;
	    /** The week number between 0 and 53. */
	    weekNumber(firstDayOfWeek: WeekDay): integer;
	    /** Adds `years` years to the date. */
	    addYears(years: integer): DateValue;
	    /** Adds `months` months to the date. */
	    addMonths(months: integer): DateValue;
	    /** Adds `weeks` weeks to the date. */
	    addWeeks(weeks: integer): DateValue;
	    /** Adds `days` days to the date. */
	    addDays(days: integer): DateValue;
	    /** The number of days between two dates. */
	    daysDiff(date: DateValue): integer;
	    /**
	     * Adds a delta which may combine years, months and days to the date.
	     *
	     * @example `d.add({ months: 2 })` adds 2 months to `d`.
	     */
	    add(delta: DateDiff): DateValue;
	    toString(): string;
	    /**
	     * formats the date according to `format`
	     * example: date.toString(format = 'YYYY-MM-DD')
	     * @param locale LocalizeLocale
	     * @param format string
	     * @returns string
	     */
	    format(fmt: string, locale?: LocalizeLocale): string;
	    at(t: time.Time, timeZone?: string, millisecond?: number): datetime.Datetime;
	    toJsDate(timeZone?: string | undefined): Date;
	    toJSON(): string;
	    isNull(): boolean;
	    static amDesignator(locale?: LocalizeLocale): string;
	    static pmDesignator(locale?: LocalizeLocale): string;
	    static monthName(month: number, locale?: LocalizeLocale, abbrev?: boolean): string;
	    static monthFromName(name: string, locale?: LocalizeLocale): number;
	    static weekDayName(weekDay: number, locale?: LocalizeLocale, abbrev?: boolean): string;
	    static weekDayFromName(name: string, locale?: LocalizeLocale): number;
	    static parse(str: string, locale?: LocalizeLocale, format?: string): DateValue;
	    static today(timeZone?: string | undefined): DateValue;
	    static fromJsDate(jsDate: Date, timeZone?: string | undefined): DateValue;
	    static fromInternalValue(value: number): DateValue;
	    static make(year: number, month: number, day: number): DateValue;
	    static makeInWeek(year: number, week: number, wday: number): DateValue;
	    static getWeekDayNames(startDay?: WeekDayName): readonly WeekDayName[];
	    static getWeekDayNumbers(startDay?: WeekDay): readonly WeekDay[];
	    static isDate(obj: any): obj is DateValue;
	}
	export const amDesignator: typeof DateValue.amDesignator;
	export const pmDesignator: typeof DateValue.pmDesignator;
	export const monthName: typeof DateValue.monthName;
	export const monthFromName: typeof DateValue.monthFromName;
	export const weekDayName: typeof DateValue.weekDayName;
	export const weekDayFromName: typeof DateValue.weekDayFromName;
	export const parse: typeof DateValue.parse;
	export const today: typeof DateValue.today;
	export const fromJsDate: typeof DateValue.fromJsDate;
	export const fromInternalValue: typeof DateValue.fromInternalValue;
	export const make: typeof DateValue.make;
	export const makeInWeek: typeof DateValue.makeInWeek;
	export const isDate: typeof DateValue.isDate;
	export const getWeekDayNames: typeof DateValue.getWeekDayNames;
	export const getWeekDayNumbers: typeof DateValue.getWeekDayNumbers;
	//# sourceMappingURL=date.d.ts.map
}
// From file: @sage/xtrem-date-time/build/lib/date-range.d.ts
declare module '@sage/xtrem-date-time/lib/date-range' {
	/** @packageDocumentation @module dateRange */
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import { DateValue, WeekDay } from '@sage/xtrem-date-time/lib/date';
	import { Range } from '@sage/xtrem-date-time/lib/range';
	export class DateRange extends Range<DateValue> {
	    static parse: typeof parse;
	    static isDateRange: typeof isDateRange;
	    static make: typeof make;
	    static getDayRange: typeof getDayRange;
	    static getMonthRange: typeof getMonthRange;
	    static getYearRange: typeof getYearRange;
	    static getDateRange: typeof getDateRange;
	    get constructorName(): string;
	    get durationInDays(): number;
	}
	export function isDateRange(obj: any): obj is DateRange;
	export function parse(str: string): DateRange;
	export function make(start: DateValue | null, end: DateValue | null, excludesStart?: boolean, excludesEnd?: boolean): DateRange;
	export function getDayRange(d: DateValue): DateRange;
	export function getMonthRange(d: DateValue): DateRange;
	export function getYearRange(d: DateValue): DateRange;
	export function getPreviousWeekRange(date: DateValue, startOfWeek: WeekDay): DateRange;
	export function getSameWeekRange(date: DateValue, startOfWeek: WeekDay): DateRange;
	export function getNextWeekRange(date: DateValue, startOfWeek: WeekDay): DateRange;
	type AggFunc = 'year' | 'month' | 'day' | 'week';
	export type DateRangeType = `${'same' | 'previous' | 'next'}-${AggFunc}` | `last-${7 | 30}-days`;
	export function getDateRange({ date: d, range, locale, }: {
	    date: string;
	    range: DateRangeType;
	    locale?: LocalizeLocale;
	}): DateRange;
	export {};
	//# sourceMappingURL=date-range.d.ts.map
}
declare module '@sage/xtrem-date-time' {
	export * from '@sage/xtrem-date-time/index';
}
