"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.$exported = void 0;
exports.generate = generate;
exports.fromBytes = fromBytes;
exports.toBytes = toBytes;
exports.fromString32 = fromString32;
exports.toString32 = toString32;
const uuid_1 = require("uuid");
/* eslint-disable no-bitwise */
const uuidRE = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/;
function toHex(byte) {
    const b = byte & 0xff;
    return b < 16 ? `0${b.toString(16)}` : b.toString(16);
}
function fromHex(str, i) {
    const code = str.charCodeAt(i);
    return code < 0x3a ? code - 0x30 : code < 0x47 ? code + 10 - 0x41 : code + 10 - 0x61;
}
exports.$exported = true;
function generate(sep = '-') {
    const newUuid = (0, uuid_1.v4)();
    if (sep === '-')
        return newUuid;
    return newUuid.replace(/-/g, sep);
}
function fromBytes(bytes) {
    let s = '';
    for (let i = 0; i < bytes.length; i += 1) {
        if (i === 4 || i === 6 || i === 8 || i === 10)
            s += '-';
        const j = i;
        const b = bytes[j];
        s += toHex(b);
    }
    // Force flattening, see generate function above for explanations
    // eslint-disable-next-line @typescript-eslint/no-unused-expressions
    s[0];
    return s;
}
function toBytes(str) {
    if (!str || str.length !== 36 || !uuidRE.test(str))
        throw new Error(`invalid uuid: ${str}`);
    const s = str.replace(/-/g, '');
    const bytes = [];
    for (let i = 0; i < 16; i += 1) {
        const j = i;
        const b = (fromHex(s, 2 * j) << 4) + fromHex(s, 2 * j + 1);
        bytes.push(b >= 128 ? b - 256 : b);
    }
    return bytes;
}
function fromString32(str) {
    return [str.substring(0, 8), str.substring(8, 12), str.substring(12, 16), str.substring(16, 20), str.substring(20)]
        .join('-')
        .toLowerCase();
}
function toString32(uuid) {
    return uuid.replace(/-/g, '');
}
//# sourceMappingURL=uuid.js.map