"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeZone = void 0;
const dayjs = require("dayjs");
const timeZonePlugin = require("dayjs/plugin/timezone");
const utcPlugin = require("dayjs/plugin/utc");
const advancedFormatPlugin = require("dayjs/plugin/advancedFormat");
const date_1 = require("./date");
const time_1 = require("./time");
const utils_1 = require("./utils");
dayjs.extend(timeZonePlugin);
dayjs.extend(utcPlugin);
dayjs.extend(advancedFormatPlugin);
class TimeZone {
    static getAvailableTimeZones() {
        return Intl.supportedValuesOf('timeZone');
    }
    /** @internal */
    static getUtcValue(timeZone, year, month, day, hour, minute, second, millis) {
        const dateStr = date_1.DateValue.make(year, month, day).toString();
        const timeStr = time_1.Time.make(hour || 0, minute || 0, second || 0).toString();
        const millisStr = millis ? (0, utils_1.pad3)(millis) : '000';
        const str = `${dateStr}T${timeStr}.${millisStr}`;
        return dayjs.tz(str, timeZone).valueOf();
    }
    /** @internal */
    static getDayjs(timeZone, value) {
        return dayjs.tz(value, timeZone);
    }
}
exports.TimeZone = TimeZone;
//# sourceMappingURL=time-zone.js.map