export declare abstract class Range<T> {
    start: T | null;
    end: T | null;
    excludesStart: boolean;
    excludesEnd: boolean;
    includedStart: T | null;
    excludedStart: T | null;
    includedEnd: T | null;
    excludedEnd: T | null;
    constructor(start: T | null, end: T | null, excludesStart?: boolean, excludesEnd?: boolean);
    abstract get constructorName(): string;
    validateRange(): void;
    abstract incrementsByRangeUnit(elm: T, step?: number): T;
    abstract getBoundValue(elm: T | null): number | null;
    abstract getStringBoundValue(elm: T | null): string;
    includes(elmToCompareWith: T | null): boolean;
    equals(rangeToCompareWith: Range<T> | null): boolean;
    toString(): string;
    toJSON(): string;
}
//# sourceMappingURL=range.d.ts.map