"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegerRange = void 0;
exports.parse = parse;
exports.isIntegerRange = isIntegerRange;
exports.make = make;
const range_1 = require("./range");
class IntegerRange extends range_1.Range {
    static { this.parse = parse; }
    static { this.isIntegerRange = isIntegerRange; }
    static { this.isValidIntegerRangeString = isValidIntegerRangeString; }
    static { this.make = make; }
    // eslint-disable-next-line class-methods-use-this
    get constructorName() {
        return 'IntegerRange';
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    incrementsByRangeUnit(elm, step = 1) {
        return elm + step;
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getBoundValue(elm) {
        if (!elm)
            return null;
        return elm;
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getStringBoundValue(elm) {
        if (!elm)
            return '';
        return elm.toString();
    }
}
exports.IntegerRange = IntegerRange;
function parse(str) {
    const integerRangeStr = str.replace(/[\s"]/g, '');
    if (!isValidIntegerRangeString(integerRangeStr)) {
        throw new Error(`Invalid integer range format: ${str}.`);
    }
    const integerRange = integerRangeStr.split(',');
    const start = integerRange[0].slice(1);
    const end = integerRange[1].slice(0, -1);
    const excludesStart = start.length === 0 || integerRange[0].slice(0, 1) === '(';
    const excludesEnd = end.length === 0 || integerRange[1].slice(-1) === ')';
    return new IntegerRange(start.length > 0 ? Number(start) : null, end.length > 0 ? Number(end) : null, excludesStart, excludesEnd);
}
function isIntegerRange(obj) {
    return obj && obj.constructorName === 'IntegerRange';
}
function isValidIntegerRangeString(str) {
    // ( or [
    const beginRangeRegex = /^(\[|\()/;
    // ) or ]
    const endRangeRegex = /(\]|\))$/;
    // integer
    const integerRegex = /(\d+)?/;
    // comma followed by at most one space
    const separatorRegex = /,/;
    const integerRangeRegex = new RegExp(`${beginRangeRegex.source}${integerRegex.source}${separatorRegex.source}${integerRegex.source}${endRangeRegex.source}`);
    return integerRangeRegex.test(str.replace(/\s/g, ''));
}
function make(start, end, excludesStart = false, excludesEnd = true) {
    return new IntegerRange(start, end, excludesStart, excludesEnd);
}
//# sourceMappingURL=integer-range.js.map