import { LocalizeLocale } from '@sage/xtrem-shared';
import { Datetime, Time } from '.';
import { DateValue } from './date';
export type DatePresetFormat = 'FullDate' | 'LongMonth' | 'LongMonthYear' | 'MonthDay' | 'MonthYear' | 'LongMonthDayYear';
type FormableDate = Date | string | DateValue | Datetime;
export declare const formatDateToCurrentLocale: (date: FormableDate, locale?: LocalizeLocale, fmt?: DatePresetFormat) => string;
type FormableTime = Date | string | Time | Datetime;
export declare const formatTimeToLocale: (time: FormableTime, locale?: LocalizeLocale) => string;
export declare const parseLocalizedDate: (date: string, locale?: LocalizeLocale, fmt?: DatePresetFormat) => DateValue;
export declare const parseIsoDate: (date: string, locale?: LocalizeLocale) => DateValue;
export declare const isValidLocalizedDate: (date: string, locale?: LocalizeLocale, fmt?: DatePresetFormat) => boolean;
export declare const isValidIsoDate: (date: string, locale?: LocalizeLocale) => boolean;
export {};
//# sourceMappingURL=formatting-utils.d.ts.map