"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DecimalRange = void 0;
exports.parse = parse;
exports.isDecimalRange = isDecimalRange;
exports.make = make;
const xtrem_decimal_1 = require("@sage/xtrem-decimal");
const range_1 = require("./range");
class DecimalRange extends range_1.Range {
    static { this.parse = parse; }
    static { this.isDecimalRange = isDecimalRange; }
    static { this.isValidDecimalRangeString = isValidDecimalRangeString; }
    static { this.make = make; }
    // eslint-disable-next-line class-methods-use-this
    get constructorName() {
        return 'DecimalRange';
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    incrementsByRangeUnit(elm) {
        // increment by scale value, ex: 1.003->1.004
        return elm.add(new xtrem_decimal_1.Decimal(10).pow(-(elm.toString().split('.')?.[1]?.length || 1)));
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getBoundValue(elm) {
        if (!elm)
            return null;
        return xtrem_decimal_1.Decimal.toNumber(elm);
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getStringBoundValue(elm) {
        if (!elm)
            return '';
        return elm.toString();
    }
}
exports.DecimalRange = DecimalRange;
function parse(str) {
    const decimalRangeStr = str.replace(/[\s"]/g, '');
    if (!isValidDecimalRangeString(decimalRangeStr)) {
        throw new Error(`Invalid decimal range format: ${str}.`);
    }
    const decimalRange = decimalRangeStr.split(',');
    const start = decimalRange[0].slice(1);
    const end = decimalRange[1].slice(0, -1);
    const excludesStart = start.length === 0 || decimalRange[0].slice(0, 1) === '(';
    const excludesEnd = end.length === 0 || decimalRange[1].slice(-1) === ')';
    return new DecimalRange(start.length > 0 ? xtrem_decimal_1.Decimal.make(start) : null, end.length > 0 ? xtrem_decimal_1.Decimal.make(end) : null, excludesStart, excludesEnd);
}
function isDecimalRange(obj) {
    return obj && obj.constructorName === 'DecimalRange';
}
function isValidDecimalRangeString(str) {
    // ( or [
    const beginRangeRegex = /^(\[|\()/;
    // ) or ]
    const endRangeRegex = /(\]|\))$/;
    // decimal
    const decimalRegex = /((\d*\.)?\d+)?/;
    // comma followed by at most one space
    const separatorRegex = /,/;
    const decimalRangeRegex = new RegExp(`${beginRangeRegex.source}${decimalRegex.source}${separatorRegex.source}${decimalRegex.source}${endRangeRegex.source}`);
    return decimalRangeRegex.test(str.replace(/\s/g, ''));
}
function make(start, end, excludesStart = false, excludesEnd = true) {
    return new DecimalRange(start ? xtrem_decimal_1.Decimal.make(start) : null, end ? xtrem_decimal_1.Decimal.make(end) : null, excludesStart, excludesEnd);
}
//# sourceMappingURL=decimal-range.js.map