import { StockUnit } from '@sage/wh-master-data/lib/interfaces';
import type { GraphApi } from '@sage/wh-pages-api';
import * as ui from '@sage/xtrem-ui';
interface AggregatedProductStoreLocation {
    _id: string;
    _key: string;
    productCode: string;
    localizedDescription: string;
    numberOfConsumptionUnit: number;
    distinctLot: number;
    distinctSerialNumber: number;
    isKeyInLotNumber: boolean;
    isKeyInSerialNumber: boolean;
    isLocalizedSerialNumberAllowed: boolean;
    isStockUnitManagement: boolean;
    stockUnit?: StockUnit;
}
interface ProductStoreLocationValue extends Omit<AggregatedProductStoreLocation, '_key' | 'distinctLot' | 'distinctSerialNumber' | 'isStockUnitManagement'> {
    distinctLot: string;
    distinctSerialNumber: string;
    consumptionUnitCode: string;
}
export declare class MobileViewStockByStoreLocationSelectProduct extends ui.Page<GraphApi> {
    /**
     * Internal properties
     */
    private _parameters;
    mainSection: ui.containers.Section;
    mainBlock: ui.containers.Block;
    storeLocation: ui.fields.Text;
    distinctProducts: ui.fields.Numeric;
    locationType: ui.fields.Text;
    referenceContainerCode: ui.fields.Text;
    products: ui.fields.Table<ProductStoreLocationValue>;
    private _initializeProductTable;
    /**
     * get query parameters
     * @returns expected parameters or undefined
     */
    private _getQueryParameters;
    /**
     * Return current parameter before chain another page
     * @return return the current parameters
     */
    private _getCurrentParameters;
    private _getUpdatedParameters;
    private _readAggregatedProducts;
}
export {};
//# sourceMappingURL=mobile-view-stock-by-store-location-select-product.d.ts.map