import type { GraphApi } from '@sage/wh-pages-api';
import * as ui from '@sage/xtrem-ui';
export interface AggregatedStoreLocation {
    _key?: string;
    storeCode: string;
    locationCode: string;
    locationType: string;
    numberOfConsumptionUnit: number;
    distinctStockObject: number;
    distinctLot: number;
    distinctSerialNumber: number;
}
export interface StoreLocationValue extends Omit<AggregatedStoreLocation, '_key' | 'distinctStockObject'> {
    _id: string;
    storeLocationCode: string;
    distinctStockObject?: number;
}
export declare class MobileViewStockByProductSelectStoreLocation extends ui.Page<GraphApi> {
    /**
     * Internal properties
     */
    private _parameters;
    mainSection: ui.containers.Section;
    mainBlock: ui.containers.Block;
    product: ui.fields.Text;
    distinctLocations: ui.fields.Numeric;
    localizedDescription: ui.fields.Text;
    distinctLots: ui.fields.Numeric;
    distinctSerialNumbers: ui.fields.Numeric;
    storesLocations: ui.fields.Table<any>;
    /**
     * get query parameters
     * @returns expected parameters or undefined
     */
    private _getQueryParameters;
    /**
     * Return current parameter before chain another page
     * @return return the current parameters
     */
    private _getCurrentParameters;
    private _getUpdatedParameters;
    private _readAggregatedProduct;
    private _readAggregatedStoreAndLocation;
}
//# sourceMappingURL=mobile-view-stock-by-product-select-store-location.d.ts.map