import type { GraphApi } from '@sage/wh-pages-api';
import * as ui from '@sage/xtrem-ui';
/**
 * Data structure for detail panel
 */
export interface StockObjectEntry {
    _id: string;
    code: string;
    containerCode: string;
    containerLevel: string;
    numberOfContainer: string;
    homogeneousContainerCode: string;
    homogeneousContainerLevel: string;
    homogeneousQuantity: string;
    consumptionUnitCode: string;
    numberOfConsumptionUnit: number | string;
    numberOfConsumptionUnitInPendingInput: number | string;
    numberOfConsumptionUnitInPendingOutput: number | string;
    lotNumber: string;
    supportNumber: string;
    reservationNumber: string;
    stockStatusCode: string;
    fifoDate?: string;
    receiptDate?: string;
    manufacturedDate?: string;
    detentionUnit?: string;
    detentionDate?: string;
    sellByDateUnit?: string;
    sellByDate?: string;
    useByDateUnit?: string;
    useByDate?: string;
    sendByDateUnit?: string;
    shipByDate?: string;
    isControlOutputFlow: boolean;
    isBlockedInOutput: boolean;
    isAuthorizedInOutput: boolean;
    isBlockedInInventory: boolean;
    stockCountCode?: string;
    distinctSerialNumber: number;
}
/**
 * Data structure for table
 */
interface StockObjectTable extends StockObjectEntry {
    numberOfConsumptionUnitExplained: string;
    distinctStockObject: number;
    distinctLot: number;
    storeCode: string;
    locationCode: string;
    storeLocation: string;
    productCode: string;
    locationType: string;
}
export declare class MobileViewStockByProductSelectStockObject extends ui.Page<GraphApi> {
    /**
     * Internal properties
     */
    private _parameters;
    mainSection: ui.containers.Section;
    detailPanelSection: ui.containers.Section;
    sectionHeader: ui.containers.Section;
    mainBlock: ui.containers.Block;
    detailsBlock: ui.containers.Block;
    storeCode: ui.fields.Text;
    locationCode: ui.fields.Text;
    productCode: ui.fields.Text;
    numberOfConsumptionUnit: ui.fields.Numeric;
    localizedDescription: ui.fields.Text;
    reserved: ui.fields.Text;
    storeLocation: ui.fields.Text;
    locationType: ui.fields.Text;
    stockObject: ui.fields.Table<StockObjectTable>;
    /**
     *  Move extracted data to stockObject transient table
     *  @param _stockObjects
     *  @param _aggregatedByStockObjects
     *  @param _parameters
     *  @returns true when stockObject table is not empty
     */
    private _initializeStockObjectTable;
    private _onRowClick;
    /**
     * get query parameters
     * @returns expected parameters or undefined
     */
    private _getQueryParameters;
    /**
     * Return current parameter before chain another page
     * @return return the current parameters
     */
    private _getCurrentParameters;
    /**
     * Return aggregated stockObject for lots / serial numbers
     * @returns
     */
    private _readAggregatedStockObjects;
    /**
     * Read stock objects for a given store / location
     * @param _parameters
     * @returns stock objects selected
     */
    private _readStockObjects;
    /**
     * Read aggregated quantities for give store / location
     * lots and serials numbers has not been aggregated
     * @param _parameters
     * @returns aggregated quantities
     */
    private _getAggregatedLocationQuantities;
    /**
     * Change title page
     * @param _parameters
     */
    private _setTitle;
}
export {};
//# sourceMappingURL=mobile-view-stock-by-product-select-stock-object.d.ts.map