/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-view-localized-serial-details.ts":
/*!***********************************************************!*\
  !*** ./lib/pages/mobile-view-localized-serial-details.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("{\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewLocalizedSerialDetails = void 0;\nconst typesLib = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst _hideWhenEmptyValue = (value, _rowValue) => {\n    return typesLib.strictNe(typeof value, 'number') && !value;\n};\nlet MobileViewLocalizedSerialDetails = class MobileViewLocalizedSerialDetails extends ui.Page {\n    /*\n     *\n     *  Fields management functions\n     *\n     */\n    async _onRowClick(recordId, rowItem) {\n        this.detailsPanelList.value = [rowItem]; // populate details list\n        await this.localizedSerialNumbers.validateWithDetails();\n        if (this.$?.detailPanel) {\n            this.$.detailPanel.isHidden = false;\n        }\n    }\n    /**\n     * get query parameters\n     * @returns expected parameters or undefined\n     */\n    _getQueryParameters() {\n        try {\n            return JSON.parse(String(this.$.queryParameters.localizedSerialNumbersArgs));\n        }\n        catch (error) {\n            ui.console.error(`Error retrieving query parameters:\\n${JSON.stringify(error)}`);\n            return undefined;\n        }\n    }\n    /**\n     * Read serialized serial numbers\n     * @param _parameters arguments parameters\n     * @returns serialized serial numbers\n     */\n    async _readLocalizedSerialNumbers(_parameters) {\n        try {\n            const _returnSerialNumbers = [];\n            const _response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/wh-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                _id: true,\n                code: true,\n                double: true,\n                occurrence: true,\n                serialGroup: { code: true },\n                serialParentGroup: { code: true },\n                free1: true,\n                free2: true,\n                free3: true,\n                free4: true,\n                free5: true,\n            }, {\n                filter: {\n                    site: {\n                        code: _parameters?.depositorSiteSelected?.siteCode,\n                    },\n                    depositor: {\n                        code: _parameters?.depositorSiteSelected?.depositorCode,\n                    },\n                    product: { code: _parameters.productCode },\n                    stockObject: { code: _parameters.stockObjectSelected.code },\n                },\n                first: 500,\n                orderBy: { keyCodeForDuplicates: 1 },\n            }))\n                .execute()) ?? [];\n            // Convert serial numbers using functional approach\n            const serialNumbers = _response.map(_serialNumber => ({\n                _id: _serialNumber._id,\n                _key: _serialNumber.keyCodeForDuplicates,\n                code: _serialNumber.code,\n                double: _serialNumber.double,\n                occurrence: _serialNumber.occurrence,\n                _uniqueCode: `${_serialNumber.code} - ${_serialNumber.double} - ${_serialNumber.occurrence}`,\n                serialGroupCode: _serialNumber?.serialGroup?.code ?? '',\n                serialParentGroupCode: _serialNumber?.serialParentGroup?.code ?? '',\n                free1: _serialNumber.free1 ?? '',\n                free2: _serialNumber.free2 ?? '',\n                free3: _serialNumber.free3 ?? '',\n                free4: _serialNumber.free4 ?? '',\n                free5: _serialNumber.free5 ?? '',\n            }));\n            _returnSerialNumbers.push(...serialNumbers);\n            return _returnSerialNumbers;\n            // return (extractEdges<unknown>(_response) as PartialCollectionValueWithIds<SerialNumber>[]) ?? [];\n        }\n        catch (error) {\n            ui.console.error(`Error reading serial numbers:\\n${JSON.stringify(error)}`);\n            return [];\n        }\n    }\n    /**\n     * Change title page\n     * @param _parameters\n     */\n    _setTitle(_parameters) {\n        this.$.page.title = _parameters?.isViewByStoreLocation\n            ? ui.localize('@sage/wh-pages/title__stock-by-store-location', 'Stock by location')\n            : ui.localize('@sage/wh-pages/title__stock-by-product', 'Stock by product');\n    }\n};\nexports.MobileViewLocalizedSerialDetails = MobileViewLocalizedSerialDetails;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n        // title: 'Serial Numbers',\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n        // title: 'Serial Numbers',\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"detailPanelSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"detailsPanelBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"productCode\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n        prefix: ui.localize('@sage/wh-pages/serial-numbers-prefix', 'Serial no.:'),\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"distinctSerialNumbers\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n        prefix: ui.localize('@sage/wh-pages/prefix-stock-object', 'SO:'),\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"stockObjectCode\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"_id\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        node: '@sage/wh-stock-data/SerialNumber',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: true,\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canUserHideColumns: false,\n        mobileCard: undefined,\n        orderBy: { _key: 1 },\n        columns: [\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title___uniqueCode\", \"Serial number\"),\n                bind: '_uniqueCode',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__code\", \"Serial number\"),\n                bind: 'code',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__double\", \"Double\"),\n                bind: 'double',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__occurrence\", \"Occurrence\"),\n                bind: 'occurrence',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__serialGroupCode\", \"Serial group\"),\n                bind: 'serialGroupCode',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__serialParentGroupCode\", \"Parent group\"),\n                bind: 'serialParentGroupCode',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__free1\", \"Free 1\"),\n                bind: 'free1',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__free2\", \"Free 2\"),\n                bind: 'free2',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__free3\", \"Free 3\"),\n                bind: 'free3',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__free4\", \"Free 4\"),\n                bind: 'free4',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__localizedSerialNumbers____columns__title__free5\", \"Free 5\"),\n                bind: 'free5',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_id',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_key',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n        async onRowClick(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"localizedSerialNumbers\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.detailsPanelBlock;\n        },\n        isTransient: true,\n        fields: [\n            // display a blank line at the top\n            ui.nestedFields.text({\n                bind: '_spacerColumn',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title\", \"Serial number\"),\n                bind: 'code',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.numeric({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__2\", \"Double\"),\n                bind: 'double',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.numeric({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__3\", \"Occurrence\"),\n                bind: 'occurrence',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__4\", \"Serial group\"),\n                bind: 'serialGroupCode',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: _hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__5\", \"Parent group\"),\n                bind: 'serialParentGroupCode',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: _hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__6\", \"Free 1\"),\n                bind: 'free1',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__7\", \"Free 2\"),\n                bind: 'free2',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__8\", \"Free 3\"),\n                bind: 'free3',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__9\", \"Free 4\"),\n                bind: 'free4',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details__detailsPanelList____fields__title__10\", \"Free 5\"),\n                bind: 'free5',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_id',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_key',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_uniqueCode',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileViewLocalizedSerialDetails.prototype, \"detailsPanelList\", void 0);\nexports.MobileViewLocalizedSerialDetails = MobileViewLocalizedSerialDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details____title\", \"Stock by product\"),\n        subtitle: ui.localize(\"@sage/wh-pages/pages__mobile_view_localized_serial_details____subtitle\", \"Serial number details\"),\n        isTitleHidden: true, // hide the page's title and render that title only in the feature header instead of in both places (see X3-177000 & https://github.com/Sage-ERP-X3/etna/pull/1785)\n        node: '@sage/wh-stock-data/SerialNumber',\n        mode: 'default',\n        isTransient: true,\n        navigationPanel: undefined,\n        authorizationCode: 'INQSTOPRO',\n        headerCard() {\n            return {\n                title: this.productCode,\n                titleRight: this.distinctSerialNumbers,\n                line2: this.localizedDescription,\n                line2Right: this.stockObjectCode,\n            };\n        },\n        detailPanel() {\n            return {\n                isCloseButtonHidden: true,\n                isTitleHidden: true,\n                isHidden: true,\n                isTransient: true,\n                header: this.detailPanelSection,\n                sections: [],\n            };\n        },\n        async onLoad() {\n            // Requires a selected product in the query parameters.  This should not occur unless user manually\n            // directs themselves to this page\n            const _parameters = this._getQueryParameters();\n            this._setTitle(_parameters);\n            this._parameters = _parameters;\n            // Requires product and stock id\n            if (_parameters &&\n                _parameters.productCode &&\n                _parameters.depositorSiteSelected &&\n                _parameters.stockObjectSelected?._id &&\n                _parameters.stockObjectSelected?.code) {\n                // Fill out header card\n                this._id.value = _parameters.stockObjectSelected._id;\n                this.productCode.value = _parameters.productCode;\n                this.localizedDescription.value = _parameters?.localizedDescription ?? null;\n                this.stockObjectCode.value = _parameters.stockObjectSelected?.code ?? null;\n                const _localizedSerialNumbers = await this._readLocalizedSerialNumbers(_parameters);\n                this.localizedSerialNumbers.value = _localizedSerialNumbers;\n                this.distinctSerialNumbers.value = _localizedSerialNumbers.length;\n                this.localizedSerialNumbers.value = _localizedSerialNumbers;\n            }\n            else {\n                this.$.showToast(ui.localize('@sage/wh-pages/notification-error-missing-params', 'Missing required parameters'), { type: 'error' });\n            }\n        },\n    })\n], MobileViewLocalizedSerialDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-localized-serial-details.ts\n\n}");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-localized-serial-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var __webpack_i__ in __webpack_exports__) __webpack_export_target__[__webpack_i__] = __webpack_exports__[__webpack_i__];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;