import type { GraphApi } from '@sage/wh-stock-data-api';
import * as ui from '@sage/xtrem-ui';
interface ReturnSerialNumber {
    _id: string;
    _key: string;
    _uniqueCode: string;
    code: string;
    double: number;
    occurrence: number;
    serialGroupCode: string;
    serialParentGroupCode: string;
    free1: string;
    free2: string;
    free3: string;
    free4: string;
    free5: string;
}
export declare class MobileViewLocalizedSerialDetails extends ui.Page<GraphApi> {
    /**
     * Internal properties
     */
    private _parameters;
    mainSection: ui.containers.Section;
    detailPanelSection: ui.containers.Section;
    mainBlock: ui.containers.Block;
    detailsPanelBlock: ui.containers.Block;
    /**
     * technical fields
     * */
    productCode: ui.fields.Text;
    distinctSerialNumbers: ui.fields.Numeric;
    localizedDescription: ui.fields.Text;
    stockObjectCode: ui.fields.Text;
    _id: ui.fields.Text;
    localizedSerialNumbers: ui.fields.Table<ReturnSerialNumber>;
    detailsPanelList: ui.fields.DetailList;
    private _onRowClick;
    /**
     * get query parameters
     * @returns expected parameters or undefined
     */
    private _getQueryParameters;
    /**
     * Read serialized serial numbers
     * @param _parameters arguments parameters
     * @returns serialized serial numbers
     */
    private _readLocalizedSerialNumbers;
    /**
     * Change title page
     * @param _parameters
     */
    private _setTitle;
}
export {};
//# sourceMappingURL=mobile-view-localized-serial-details.d.ts.map