import type { ReceiptMovementAddressedBinding } from '@sage/wh-input-api-partial';
import type { GraphApi } from '@sage/wh-pages-api';
import type { SerialNumberBinding } from '@sage/wh-stock-data-api';
import * as ui from '@sage/xtrem-ui';
export declare class MobilePutaway extends ui.Page<GraphApi> {
    /** internal properties */
    private _siteCodeSelected?;
    private _depositorCodeSelected?;
    private _inputMovementSelected?;
    private _currentMovementNumber;
    private _maxMovementNumber;
    private _productConfiguration?;
    private _productPalletizationPlan;
    private _serialNumberManagement;
    private _containerConsumptionOrUpcUnit?;
    private _controlCode?;
    private _saveStoreLocation;
    cancelButton: ui.PageAction;
    readdressingButton: ui.PageAction;
    nextButton: ui.PageAction;
    createButton: ui.PageAction;
    /**
     * 🔴 Error handling for create button
     * @param e
     * @param noCancelButton if true, no cancel button is displayed
     */
    private _onError_createButton;
    /**
     * 🔴 Error handling and ask the user if they should start again
     *
     * @param e  error
     * @param noCancelButton if true, no cancel button is displayed
     * @returns return true to restart the operation
     */
    private _dialogError;
    mainSection: ui.containers.Section;
    validateMovementSection: ui.containers.Section;
    declareSerialNumbersSection: ui.containers.Section;
    readdressingSection: ui.containers.Section;
    mainBlock: ui.containers.Block;
    validateMovementBlock: ui.containers.Block;
    declareSerialNumbersBlock: ui.containers.Block;
    readdressingBlock: ui.containers.Block;
    /**
     * Case of movement validation section
     */
    storingListHeader: ui.fields.Text;
    /**
     * Case of serial numbers section
     */
    inputMovementHeader: ui.fields.Text;
    productHeader: ui.fields.Text;
    locationHeader: ui.fields.Text;
    putawayQuantityHeader: ui.fields.Numeric;
    storingList: ui.fields.Reference;
    receiptMovementAddressed: ui.fields.Reference;
    inputMovements: ui.fields.Table<ReceiptMovementAddressedBinding>;
    inputMovement: ui.fields.Reference;
    product: ui.fields.Reference;
    storeLocationCode: ui.fields.Text;
    barcodeStoreLocation: ui.fields.Text;
    /**
     * Checks if the given barcode store location is valid for the product.
     * @param barcodeStoreLocation The barcode store location to check or undefined for readdressing field.
     * @returns True if the location is valid, false otherwise.
     */
    private _isValidLocationForProduct;
    /**
     * Checks if the given barcode store location is valid for the product.
     * The check will verify the original location unless a new one is specified,
     * in which case it must be different.
     * All checks are applied when the barcode is provided because it is a control field, not a readdressing field.
     * @param barcodeStoreLocation The barcode store location to check or undefined for readdressing field.
     * @returns An error message if the location is invalid, or undefined if it is valid.
     */
    private _checkLocationForProduct;
    container: ui.fields.DropdownList;
    numberOfContainers: ui.fields.Numeric;
    homogeneousContainer: ui.fields.DropdownList;
    homogeneousQuantity: ui.fields.Numeric;
    /**
     * Updates the homogeneous quantity in the consumption unit.
     * @returns True if the update was successful, false otherwise.
     */
    private _updateHomogeneousQuantityInConsumptionUnit;
    serialGroup: ui.fields.Reference;
    serialNumber: ui.fields.FilterSelect;
    serialNumbers: ui.fields.Table<SerialNumberBinding>;
    /**
     *  Indicates whether the deletion of a serial number is allowed.
     * @param record  The row item associated with the record.
     * @returns  True if the deletion is allowed, false otherwise.
     */
    private _isSerialNumberDeletionAllowed;
    currentStoreLocation: ui.fields.Text;
    newStoreLocation: ui.fields.Reference;
    /**
     * Initialize the business actions for the page
     * @returns List of business actions
     */
    private _getBusinessActions;
    /**
     * Initialize the page
     * @returns True if the page is correctly initialized, false otherwise
     */
    private _initialize;
    /**
     *  Initialize the site and depositor from the user function profile
     * @returns True if the site and depositor are correctly initialized, false otherwise
     */
    private _initSiteDepositor;
    /**
     * Disable the page
     * Used when there is a blocking problem
     */
    private disablePage;
    /**
     * Set the active section
     * The section will only be made visible at the end, so as not to have the various
     * changes made to the section.
     * @param section target section
     * @param parameters optional parameters
     * @returns activated section
     */
    private _setActiveSection;
    /**
     * Get the active section
     * @returns active section
     */
    private _getActiveSection;
    /**
     * 🔸Update receipt button disabled state :
     *
     * Acceptance of the sequence of movements phase is:
     * - Either we're not entering movements.
     * - Either there are no more quantities to receive.
     * - or there are saved movements, which have been completely deleted because the user no longer wants the movements entered.
     *
     */
    private _updateButtonsState;
    /**
     * Reinitialize pending movements with optional fields selectors.
     * @param _includeSelector If true, resets relevant state (default: false)
     */
    private _reinitializePendingReceiptMovements;
    /**
     *  Get the error message associated with a serial number management error code.
     * @param errorCode
     * @returns
     */
    private _displaySerialNumberManagementError;
    /**
     * Set subtitle for active section
     * @returns true when subtitle has changed
     */
    private _setSubTitleForSection;
    /**
     * Confirm delete dialog
     * @param optional message
     * @returns true if the user confirms the deletion
     */
    private _dialogConfirmDelete;
    /** Initialize primary page */
    private _initFieldsDestination;
    /**
     * ⚪ Main block management
     */
    /**
     * Reinitialize fields for main block filter
     * @returns true when done
     */
    private _initEnterMainBlockHeader;
    /**
     *  Update main section information
     *  @param refresh
     *  @returns true when exists receipt lines
     */
    private _initEnterMainBlock;
    /**
     * ⚪ Validate movement block management
     */
    /**
     * Initialize validate movement block
     *
     * @param _previousSection  previous section
     * @returns
     */
    private _initEnterValidateMovementBlockHeader;
    /**
     * Set the validate movement header
     */
    private _initEnterValidateMovementBlock;
    /**
     * Get the store and location codes of the selected movement or the new location if readdressed
     * @returns the store and location codes of the selected movement
     */
    private _getStoreLocationFromMovement;
    /**
     * Get the control code of the selected movement if mandatory
     * @returns the control code of the current location selected movement or undefined
     */
    private _getControlCodeFromMovement;
    /**
     * Get the homogeneous quantity in consumption unit
     * @returns The homogeneous quantity in consumption unit
     */
    private _getHomogeneousQuantityInConsumptionUnit;
    /**
     * ⚪ localized serial numbers block management
     */
    /**
     * Set the declare serial numbers header
     */
    private _initEnterDeclareSerialNumbersHeader;
    /**
     * Add serial numbers localized in grid ?
     * @returns true when done
     */
    private _initEnterDeclareSerialNumbersBlock;
    /**
     * ⚪ readdressing block management
     */
    /**
     * Set the readdressing movement header
     */
    private _initEnterReaddressingHeader;
    /**
     * Update address in current movement
     * @returns true when done
     */
    private _initEnterReaddressingBlock;
    /**
     * Positions itself on the 1st movement and returns its ID otherwise undefined.
     *
     * @returns movement ID or undefined
     */
    private _selectFirstMovement;
    /**
     * Deletes the first existing movement then selects the next one if it exists.
     * If no movement is left, the selection will be cleared and a message will be displayed.
     *
     * @returns ID of the next selected move or undefined
     */
    private _selectNextMovement;
    /**
     * Sets the next movement as current and activates the movement validation section.
     * @returns
     */
    private _setSectionNextMovement;
    /**
     * Deletes the first existing movement
     *
     * @returns True if the 1st record could be deleted
     */
    private _removeFirstMovement;
    /**
     * Replaces the storing list, adds a movement input or clears the table.
     *
     * @param storingListCode  storing list number to replace OR
     * @param receiptMovementAddressedCode input movement to add
     * @returns count of movements in the table
     */
    private _getInputMovement;
    /**
     *
     * @param a first movement
     * @param b second movement
     * @returns
     */
    private _movementComparator;
    /**
     * 🔶 Get receipt movements addressed by storing list code
     * @param storingListCode
     * @returns returns the list of available movements
     */
    private _getReceiptMovementAddressedByStoringListCode;
    /**
     * 🔶 Get receipt movement addressed by movement code
     * @param receiptMovementAddressedCode
     * @returns returns the available move unless it is already in the cache
     */
    private _getReceiptMovementAddressedByMovementCode;
    /**
     * 🔶 This function is used to get administrative lines by custom functions
     * @param _localFilter
     * @returns
     */
    private _getReceiptMovementAddressedInternal;
    /**
     * 🔶 Add products consumption units to receipt movements
     * @param _receiptMovementAddressed The receipt movements addressed
     */
    private _addProductsConsumptionUnitsToReceiptMovements;
    /**
     * 🟡 Prepare the import payload
     * @param operatorCode The operator code
     * @returns {ImportStoringList} The import payload
     */
    private prepareDataMutation;
    /**
     * 🟡 Call the creation API
     * @param operatorCode The operator code
     * @returns {any} The result of the API call
     */
    private _callCreationAPI;
}
//# sourceMappingURL=mobile-putaway.d.ts.map