import type { AdministrativeReceiptLineInProgressBinding, AdministrativeReceiptMovementInProgressBinding } from '@sage/wh-input-api';
import type { GraphApi } from '@sage/wh-pages-api';
import * as ui from '@sage/xtrem-ui';
import type { PartialCollectionValueWithIds } from '@sage/xtrem-ui/build/lib/component/types';
export declare class MobileAdministrativeReceipt extends ui.Page<GraphApi> {
    /** internal properties */
    private _siteCodeSelected?;
    private _depositorCodeSelected?;
    private _siteConfiguration?;
    private _depositorConfiguration?;
    private _productConfiguration?;
    private _receiptLines;
    private _productPalletizationPlan;
    private _containerConsumptionOrUpcUnit?;
    private _receiptMovementNumber;
    private _receiptLineNumber;
    private _isNewLine;
    private _temporaryReceivedMovements;
    private _productsWithSuppliers;
    private _groupedProductsWithSuppliers;
    private _fifoManagement?;
    createButton: ui.PageAction;
    private _onError_createButton;
    cancelButton: ui.PageAction;
    receiptButton: ui.PageAction;
    receiptMovementSectionButton: ui.PageAction;
    addToReceiptButton: ui.PageAction;
    /**
     * Before validating the page, checks other related fields.
     * @param line The administrative receipt line to validate.
     * @returns True if the validation passes, false otherwise.
     */
    _beforeValidatePageForLine(line: PartialCollectionValueWithIds<AdministrativeReceiptLineInProgressBinding> | undefined): Promise<boolean>;
    mainSection: ui.containers.Section;
    selectLineSection: ui.containers.Section;
    enterLineSection: ui.containers.Section;
    enterMovementSection: ui.containers.Section;
    stockHeaderSection: ui.containers.Section;
    mainBlock: ui.containers.Block;
    receiptBlock: ui.containers.Block;
    gridBlock: ui.containers.GridRowBlock;
    gridLinesBlock: ui.containers.Block;
    customizationAdministrativeReceiptLinesBlock: ui.containers.Block;
    customizationAdministrativeReceiptMovementsBlock: ui.containers.Block;
    selectLineBlock: ui.containers.Block;
    enterLineBlock: ui.containers.Block;
    enterMovementBlock: ui.containers.Block;
    stockLineBlock: ui.containers.Block;
    /**
     * Case of line selection
     */
    administrativeReceiptCodeHeader: ui.fields.Text<MobileAdministrativeReceipt>;
    administrativeReceiptStatusCodeHeader: ui.fields.DropdownList;
    supplierBarCodeModeHeader: ui.fields.DropdownList;
    supplierBarCodeValueHeader: ui.fields.Text<MobileAdministrativeReceipt>;
    /**
     * * Case of product selection
     */
    productCodeHeader: ui.fields.Text<MobileAdministrativeReceipt>;
    productLocalizedDescriptionHeader: ui.fields.Text<MobileAdministrativeReceipt>;
    expectedInputCodeHeader: ui.fields.Text<MobileAdministrativeReceipt>;
    remainingQuantityHeader: ui.fields.Numeric<MobileAdministrativeReceipt>;
    receivedQuantityHeader: ui.fields.Numeric<MobileAdministrativeReceipt>;
    packedQuantityHeader: ui.fields.Numeric<MobileAdministrativeReceipt>;
    administrativeReceipt: ui.fields.Reference;
    isDripAndDropAllowed: ui.fields.Checkbox;
    defaultMode: ui.fields.DropdownList;
    supplierBarCode: ui.fields.Reference;
    supplierEanCode: ui.fields.Reference;
    supportNumberCode: ui.fields.Reference;
    product: ui.fields.Reference;
    administrativeReceiptLines: ui.fields.NestedGrid<[
        AdministrativeReceiptLineInProgressBinding,
        AdministrativeReceiptMovementInProgressBinding
    ]>;
    selectedAdministrativeReceiptLines: ui.fields.Table<AdministrativeReceiptLineInProgressBinding>;
    receivedQuantity: ui.fields.Numeric;
    inputContainerUnit: ui.fields.DropdownList;
    stockStatus: ui.fields.Reference;
    isDispute: ui.fields.Checkbox;
    isPutaway: ui.fields.Checkbox;
    store: ui.fields.Reference;
    isExclusiveStore: ui.fields.Checkbox;
    lotNumber: ui.fields.Text;
    reservationNumber: ui.fields.Text;
    supportNumber: ui.fields.Text;
    manufacturedDate: ui.fields.Date;
    sellByDate: ui.fields.Date;
    detentionDate: ui.fields.Date;
    useByDate: ui.fields.Date;
    shipByDate: ui.fields.Date;
    fifoDate: ui.fields.Date;
    pendingAdministrativeReceiptLines: ui.fields.Table<AdministrativeReceiptLineInProgressBinding>;
    inputContainer: ui.fields.DropdownList;
    numberOfContainers: ui.fields.Numeric;
    homogeneousContainer: ui.fields.DropdownList;
    homogeneousQuantity: ui.fields.Numeric;
    packedQuantity: ui.fields.Numeric;
    administrativeReceiptMovements: ui.fields.Table<AdministrativeReceiptMovementInProgressBinding>;
    /**
     * Create a new Sidebar for administrative receipt lines
     * @returns
     */
    private _getSidebarAdministrativeReceiptLine;
    /**
     *  Create a new Sidebar for administrative receipt movements
     * @returns
     */
    private _getSidebarAdministrativeReceiptMovement;
    /**
     * Initialize the business actions for the page
     * @returns
     */
    private _getBusinessActions;
    private _initialize;
    private _initSiteDepositor;
    /**
     * Load current site configuration, assign default mode and full list
     */
    private _initDefaultMode;
    /**
     * Load current site and depositor configuration
     *  @returns  true when done
     */
    private _getSiteAndDepositorConfiguration;
    /** Initialize primary page */
    private _initFieldsDestination;
    /**
     * Reinitialize fields for main block filter
     * @param newDefaultValue or empty string to reset all fields
     * @returns true when done
     */
    private _initEnterMainBlock;
    /**
     *  Update the state of the product field
     */
    private _updateProductState;
    /**
     *
     * @returns a filter for the supplier product upc
     */
    private _getFilterSupplierProductUpc;
    /**
     * All products are grouped with their common suppliers, and there will be as many entries of the same product as needed.
     * @returns
     */
    private _groupProductsByCommonSuppliers;
    private _reinitializedWorkingLineAndMovements;
    /**
     * Set the line selection header
     */
    private _setLineSelectionHeader;
    /**
     * Set the enter line header
     */
    private _setEnterLineHeader;
    /**
     *  Update current remaining quantity for header
     */
    private _updateRemainingQuantityHeader;
    /**
     *  Update current remaining quantity after deletion
     */
    private _updateRemainingQuantityLineAfterDelete;
    /**
     * Add a new line in administrative receipt line grid
     * @returns true when done
     */
    private _initEnterLineBlock;
    /**
     *  Initialize the new line or restore the movements
     * @param parameters
     */
    private _initializeNewLine;
    /**
     * Initialize the container unit fields
     * @param currentLine
     */
    private _loadReceiptLineData;
    /**
     * Update store values after updating stock status
     * @param _line
     */
    private _updateStoreValues;
    /**
     *  Update administrative receipt line counter evaluated from :
     * - the base lines (only when is necessary to create a new line)
     * - the pending lines (level 1 = current editing)
     * - the final grid lines (level 0 = stored)
     * Only when is necessary to create a new line
     *  @param parameters optional parameters for the new line
     * @returns the next spit line number
     */
    private _updateReceiptLineNumberCounter;
    /**
     *  Update administrative receipt movements counter
     */
    private _updateReceiptMovementNumberCounter;
    /**
     * Set the enter movement header
     */
    private _setEnterMovementHeader;
    /**
     * Add a new movement in administrative receipt line grid
     * @returns true when done
     */
    private _initMovementBlock;
    /**
     * Recalculate possible movement plan
     * @returns
     */
    private _recalculateMovementPlan;
    /**
     * Change current block for valid selection and reset edit field
     * @param newDefaultValue
     */
    private _ChangeSelectionMode;
    private _showWorkflowLayout;
    private disablePage;
    /**
     * Get administrative lines by supplier barcode
     * @param orderReference
     * @param lineReference
     * @returns
     */
    private _getAdministrativeLinesBySupplierBarCode;
    /**
     *  Get administrative lines by supplier upc code
     * @param supplierUpcCode
     * @returns
     */
    private _getAdministrativeLinesBySupplierUpcCode;
    /**
     * Get administrative lines by support number
     * @param supportNumber
     * @returns
     */
    private _getAdministrativeLinesBySupportNumber;
    /**
     * Get administrative line details with current values
     */
    private _getReceiptLineDetails;
    /**
     * Get working administrative receipt line stored in the grid (level 0)
     * @param _line
     * @returns
     */
    private _getWorkingAdministrativeReceiptLineInProgress;
    /**
     * Get pending administrative receipt line in table (current editing level 1)
     *  @param _line line to check
     * @returns
     * */
    private _getPendingAdministrativeReceiptLineInProgress;
    /**
     * This function is used to get administrative lines by custom functions
     * @param _localFilter
     * @returns
     */
    private _getAdministrativeLinesInternal;
    /**
     * Add product consumption unit to all receipt lines
     * @param _receiptLines
     */
    private _addProductsConsumptionUnitsToReceiptLines;
    /**
     * Set the active section
     * The section will only be made visible at the end, so as not to have the various
     * changes made to the section.
     * @param section target section
     * @param parameters optional parameters
     * @returns activated section
     */
    private _setActiveSection;
    /**
     * Update receipt button disabled state :
     *
     * Acceptance of the sequence of movements phase is:
     * - Either we're not entering movements.
     * - Either there are no more quantities to receive.
     * - or there are saved movements, which have been completely deleted because the user no longer wants the movements entered.
     *
     */
    private _updateReceiptButtonsState;
    /**
     * Get the active section
     * @returns active section
     */
    private _getActiveSection;
    /**
     * Set subtitle for active section
     * @returns true when subtitle has changed
     */
    private _setSubTitleForSection;
    /**
     * Get the received quantity in consumption unit or pending received quantities
     *  @returns {number} The received quantity in consumption unit reduced of pending received quantities
     */
    private _getInitialReceivedQuantityInConsumptionUnit;
    /**
     * Get the remaining quantity in consumption unit
     * @returns {number} The remaining quantity in consumption unit
     */
    private _getInitialRemainingQuantityInConsumptionUnit;
    /**
     * Get the remaining quantity in consumption unit for expected line
     * @param line optional line to get the remaining quantity in consumption unit (if not provided,
     *             the first selected line will be used)
     * @returns {number} The remaining quantity in consumption unit
     */
    private _getInitialRemainingQuantityInConsumptionUnitForExpectedLine;
    /**
     *  Get the stored received quantity in consumption unit for expected line
     * @param line optional line to get the stored received quantity in consumption unit (if not provided,
     *             the first selected line will be used)
     * @returns {number} The stored received quantity in consumption unit for expected line
     */
    private _getStoredReceivedQuantityInConsumptionUnitForExpectedLine;
    /**
     * Get the stored and pending received quantities in consumption unit
     * @returns {number} The stored and pending received quantities in consumption unit
     */
    private _getStoredAndPendingReceivedQuantityInConsumptionUnit;
    /**
     * Get the pending received quantities in consumption unit
     * @returns {number} The pending received quantities in consumption unit
     */
    private _getPendingQuantityInConsumptionUnit;
    /**
     *  Return from the received quantity in consumption / container unit
     *  @param receivedQuantity The received quantity when it is not in the field
     * @returns {number} The received quantity in consumption unit
     */
    private _getReceivedQuantityInConsumptionUnit;
    /**
     * Get the received quantity in container unit
     * @param receivedQuantity The received quantity in consumption unit
     * @returns {number} The received quantity in container unit
     */
    private _getReceivedQuantityInContainerUnit;
    private _updateReceivedQuantityAfterDelete;
    /**
     *  Get the received quantity in consumption unit for movement
     * @returns {number} The received quantity in consumption unit for movement
     */
    private _getReceivedQuantityInConsumptionUnitForMovement;
    /**
     *  Get the movement received quantity in consumption unit
     * @returns {number} The pending received quantities movements in consumption unit
     */
    private _getMovementReceivedQuantityInConsumptionUnit;
    /**
     * Get the movement remaining quantity in consumption unit
     * @returns {number} The remaining quantity in consumption unit
     */
    private _getMovementRemainingQuantityInConsumptionUnit;
    /**
     * Get the packed quantity
     * @returns {number} The packed quantity
     */
    private _getMovementsPackedQuantity;
    /**
     * Get the packed quantity
     * @returns {number} The packed quantity
     */
    private _getMovementPackedQuantity;
    /**
     *  Update main section information
     *  @param refresh
     *  @returns true when exists receipt lines
     */
    private _updateMainSectionInformation;
    /**
     * Update received and packed quantity
     */
    private _updateReceivedAndPackedQuantityAfterDelete;
    /**
     * Init container units
     */
    private _initContainerUnitFields;
    /**
     * Select single line and hide the block
     * @param recordId
     * @param rowItem
     */
    private _onRowClick_Selected;
    /**
     * Add a new movement in administrative receipt line grid (_id not reinitialized)
     * @param includeMovements
     * @returns
     */
    private _getAdministrativeReceiptLineInProgressBinding;
    /**
     * Add a new movements in administrative receipt line grid
     * @returns
     */
    private _getAdministrativeReceiptMovementInProgressBinding;
    /**
     * Add a new movement in administrative receipt movement in progress
     * @returns
     */
    private _getAdministrativeReceiptMovementInProgress;
    /**
     * Get highest administrative receipt line number
     * @returns
     */
    private _getMaximumAdministrativeReceiptLineNumber;
    /**
     *  Get products on administrative receipt
     * @returns
     */
    private _getProductsOnAdministrativeReceipt;
    private _dialogConfirmDelete;
    /**
     * Prepare the import payload
     * @param operatorCode The operator code
     * @returns {ImportAdministrativeReceipt} The import payload
     */
    private prepareDataMutation;
    /**
     * Call the creation API
     * @param operatorCode The operator code
     * @returns {any} The result of the API call
     */
    private _callCreationAPI;
}
//# sourceMappingURL=mobile-administrative-receipt.d.ts.map