import { ConsumptionUnit } from '@sage/wh-product-data/lib/interfaces';
import { StockObjectSelected } from '@sage/wh-stock-data/lib/interfaces';
import { SiteDepositorSelected, StockUnit, StoreLocationSelected } from '@sage/wh-master-data/lib/interfaces';
/**
 * OS id and productCode are required to fetch the localized serial numbers.
 */
export interface LocalizedSerialNumbersArgs {
    isViewByStoreLocation?: boolean;
    _id: string;
    productCode: string;
    localizedDescription?: string;
    depositorSiteSelected: SiteDepositorSelected;
    stockObjectSelected: StockObjectSelected;
}
export interface StockByProductArgsHeader {
    stockByProductArgs: string;
}
export interface StockByProductArgs {
    isViewByStoreLocation?: boolean;
    _id: string;
    productCode: string;
    localizedDescription?: string;
    isKeyInLotNumber?: boolean;
    isKeyInSerialNumber?: boolean;
    isLocalizedSerialNumberAllowed: boolean;
    isHazardousMaterials?: boolean;
    isStockUnitManagement?: boolean;
    consumptionUnit?: ConsumptionUnit;
    stockUnit?: StockUnit;
    siteDepositorSelected: SiteDepositorSelected;
    storeLocationSelected?: StoreLocationSelected;
    stockObjectSelected?: StockObjectSelected;
}
//# sourceMappingURL=arguments.d.ts.map