"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SortConditionEditor = SortConditionEditor;
const flat_table_1 = require("../flat-table/flat-table");
const responsive_grid_1 = require("../responsive-grid/responsive-grid");
const React = __importStar(require("react"));
const lodash_1 = require("lodash");
const order_cell_renderer_1 = require("./order-cell-renderer");
const sort_condition_utils_1 = require("./sort-condition-utils");
const property_cell_renderer_1 = require("./property-cell-renderer");
function SortConditionEditor({ canAddNewLines, canDrag = true, canRemoveLines = true, getPropertySubtitle, gridGutter, localize, onChange, properties, propertyReadOnly = false, value, }) {
    const orderByTranslations = (0, sort_condition_utils_1.getOrderByTranslations)(localize);
    const onCellChange = React.useCallback(({ columnId, rowId, value }) => {
        setTableDefinition(current => {
            return {
                ...current,
                data: current.data.reduce((acc, curr) => {
                    if (curr._id === rowId) {
                        (0, lodash_1.set)(curr, columnId, value || undefined);
                        // Set type and path for given property
                        if (curr.property?.id) {
                            const prop = properties?.[curr.property.id];
                            curr.path = prop?.id;
                            curr.labelPath = prop?.labelPath;
                        }
                    }
                    acc.push(curr);
                    return acc;
                }, []),
            };
        });
    }, [properties]);
    // Counter to keep track of table IDs
    const counterRef = React.useRef(Object.keys(value ?? {}).length);
    const onRowAdded = React.useCallback(() => {
        setTableDefinition(current => {
            counterRef.current += 1;
            const newRow = {
                _id: String(counterRef.current),
                property: undefined,
                order: undefined,
                type: undefined,
                path: undefined,
                labelPath: undefined,
                node: undefined,
            };
            return {
                ...current,
                data: [...current.data, newRow],
            };
        });
    }, []);
    const onRowRemoved = React.useCallback((removedRow) => {
        setTableDefinition(current => {
            return {
                ...current,
                data: current.data.filter(element => element._id !== removedRow._id),
            };
        });
    }, []);
    const onRowDrag = React.useCallback(ids => {
        setTableDefinition(current => {
            const orderedRows = (0, lodash_1.sortBy)(current.data, item => {
                return ids.indexOf(item._id);
            });
            return {
                ...current,
                data: orderedRows,
            };
        });
    }, []);
    const columns = React.useMemo(() => {
        return [
            { id: 'path', isHidden: !propertyReadOnly, header: { name: 'Path' } },
            {
                id: 'property',
                header: { name: localize('@sage/xtrem-ui-components/property', 'Property'), width: 400 },
                // eslint-disable-next-line react/no-unstable-nested-components
                cellRenderer: ({ rowData, data: allData }) => (React.createElement(property_cell_renderer_1.PropertyCellRenderer, { readOnly: propertyReadOnly, rowData: rowData, localize: localize, onCellChange: onCellChange, allData: allData, properties: properties, getPropertySubtitle: getPropertySubtitle })),
            },
            {
                id: 'order',
                header: { name: localize('@sage/xtrem-ui-components/sort-order', 'Order'), width: 300 },
                // eslint-disable-next-line react/no-unstable-nested-components
                cellRenderer: ({ rowData }) => (React.createElement(order_cell_renderer_1.OrderCellRenderer, { rowData: rowData, localize: localize, onCellChange: onCellChange, orderByTranslations: orderByTranslations })),
            },
            { id: 'labelPath', isHidden: true, header: { name: 'Label path' } },
        ];
    }, [localize, properties, onCellChange, orderByTranslations, getPropertySubtitle, propertyReadOnly]);
    const data = React.useMemo(() => {
        const entries = Object.entries(value ?? {});
        return entries
            .filter(([id]) => properties?.[id])
            .map(([id, order], index) => {
            const propertyDetails = properties[id];
            return {
                _id: String(index + 1),
                property: propertyDetails,
                order,
                type: propertyDetails.data?.type,
                path: id,
                labelPath: propertyDetails.labelPath,
                node: propertyDetails.data?.node,
            };
        });
    }, [value, properties]);
    const addButtonText = React.useMemo(() => localize('@sage/xtrem-ui-components/add-sort-condition', 'Add a sort condition'), [localize]);
    const [tableDefinition, setTableDefinition] = React.useState({
        addButtonText,
        isAddButtonHidden: Object.keys(properties).length === 0,
        emptyStateText: Object.keys(properties).length === 0
            ? localize('@sage/xtrem-ui-components/widget-editor-no-sortable-properties', 'You cannot sort the current values. You can select different data or continue without sorting.')
            : undefined,
        canDrag,
        onRowDrag,
        canAddNewLines,
        canRemoveLines,
        onRowRemoved,
        onRowAdded,
        columns,
        data,
    });
    React.useEffect(() => {
        onChange(tableDefinition.data
            .filter(p => p.property != null && p.order != null && p.path != null && p.labelPath != null)
            .reduce((prevValue, { order, path }) => {
            if (path && order) {
                prevValue[path] = order;
            }
            return prevValue;
        }, {}));
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [tableDefinition.data]);
    return (React.createElement(responsive_grid_1.GridRow, { columns: 8, gutter: gridGutter, margin: 0, verticalMargin: 0 },
        React.createElement(responsive_grid_1.GridColumn, { columnSpan: 8 },
            React.createElement(flat_table_1.FlatTable, { ...tableDefinition, canAddNewLines: canAddNewLines, canRemoveLines: canRemoveLines, actionsText: localize('@sage/xtrem-ui-components/actions', 'Actions') }))));
}
//# sourceMappingURL=sort-condition-editor.js.map