"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyCellRenderer = PropertyCellRenderer;
const React = __importStar(require("react"));
const select_1 = require("carbon-react/esm/components/select");
const property_table_header_1 = require("../property-template-header/property-table-header");
function PropertyCellRenderer({ rowData, localize, onCellChange, properties, allData, getPropertySubtitle, readOnly = false, }) {
    return (React.createElement(select_1.FilterableSelect, { readOnly: readOnly, multiColumn: true, tableHeader: React.createElement(property_table_header_1.PropertyTableHeader, { localize: localize }), openOnFocus: true, "data-testid": `e-widget-editor-sorting-property-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({ columnId: 'property', rowId: rowData._id, value: properties[value] || null });
        }, placeholder: localize('@sage/xtrem-ui-components/select-property', 'Select property...'), size: "small", 
        // @ts-expect-error value is nullable
        value: rowData.property?.id ?? null }, Object.keys(properties)
        .filter(p => !allData
        .filter(item => item.property && item._id !== rowData._id)
        .map(item => item.path)
        .includes(p))
        .map(p => {
        return (React.createElement(select_1.OptionRow, { text: properties[p].label, value: p, key: p },
            React.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                } }, properties[p].label),
            getPropertySubtitle && (React.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                    textAlign: 'end',
                } }, getPropertySubtitle(properties[p])))));
    })));
}
//# sourceMappingURL=property-cell-renderer.js.map