"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFilteredParameters = getFilteredParameters;
exports.ParameterValueInput = ParameterValueInput;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const react_1 = __importDefault(require("react"));
const select_1 = require("carbon-react/esm/components/select");
const utils_1 = require("../utils");
const lodash_1 = require("lodash");
const button_1 = __importDefault(require("carbon-react/esm/components/button"));
function getFilteredParameters(noParameterFiltering, property, parameters = []) {
    if (noParameterFiltering) {
        return parameters;
    }
    if (!property || !parameters) {
        return [];
    }
    const normalizedExpectedType = utils_1.NUMERIC_TYPES.includes(property.data.type) ? xtrem_shared_1.GraphQLTypes.Int : property.data.type;
    return parameters.filter(i => {
        const normalizedCurrentType = utils_1.NUMERIC_TYPES.includes(i.type) ? xtrem_shared_1.GraphQLTypes.Int : i.type;
        return (normalizedCurrentType === normalizedExpectedType ||
            (property.data.name?.split('.').at(-1) === '_id' && i.type === 'reference'));
    });
}
function ParameterValueInput({ isDisabled, localize, onCellChange, rowData, parameters = [], columnId, controlledValue, noParameterFiltering = false, 'data-testid': dataTestId = 'e-widget-editor-filter-value', filterValueAction, filterValueActionLabel, }) {
    const filteredParameters = getFilteredParameters(noParameterFiltering, rowData?.property, parameters);
    const externalValue = (0, lodash_1.isArray)(rowData[columnId]) ? rowData[columnId][0] : rowData[columnId];
    return (react_1.default.createElement(select_1.FilterableSelect, { listActionButton: filterValueAction && (react_1.default.createElement(button_1.default, { iconType: "add", iconPosition: "after" }, filterValueActionLabel ?? localize('@sage/xtrem-ui-components/add-property', 'Add property'))), onListAction: () => {
            if (filterValueAction) {
                filterValueAction();
            }
        }, disabled: isDisabled, openOnFocus: true, "data-testid": `${dataTestId}-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId,
                rowId: rowData._id,
                value: value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/select-value-placeholder', 'Select value...'), size: "small", value: controlledValue !== undefined ? controlledValue : (externalValue ?? '') }, filteredParameters.map(v => (react_1.default.createElement(select_1.Option, { key: v.label || v.name, text: v.label || v.name, value: v.name }, v.label)))));
}
//# sourceMappingURL=parameter-value-input.js.map