"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateValueInput = DateValueInput;
const react_1 = __importDefault(require("react"));
const date_1 = __importDefault(require("carbon-react/esm/components/date"));
const i18n_provider_1 = __importDefault(require("carbon-react/esm/components/i18n-provider"));
function DateValueInput({ carbonLocale, errors, isDisabled, locale, onCellChange, rowData, columnId, 'data-testid': dataTestId = 'e-widget-editor-filter-value', }) {
    return (react_1.default.createElement("div", { className: "e-widget-editor-flat-table-date" },
        react_1.default.createElement(i18n_provider_1.default, { locale: carbonLocale(locale || 'en-US') },
            react_1.default.createElement(date_1.default, { "data-testid": `${dataTestId}-${rowData._id}`, error: errors?.[rowData._id]?.filterValue, disabled: isDisabled, size: "small", readOnly: isDisabled, tooltipPosition: "top", allowEmptyValue: true, value: rowData[columnId]?.formattedValue || rowData[columnId]?.rawValue || '', onChange: (ev) => {
                    onCellChange({
                        columnId,
                        rowId: rowData._id,
                        value: ev.target.value,
                        rowData,
                    });
                } }))));
}
//# sourceMappingURL=date-value-input.js.map