"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GridRow = GridRow;
exports.GridColumn = GridColumn;
const react_1 = __importDefault(require("react"));
function GridRow(props) {
    const verticalMargin = props.verticalMargin ?? 16;
    return (react_1.default.createElement("div", { className: `e-grid-row e-grid-row-${props.columns} ${props.className || ''}`, onScroll: props.onScroll, style: {
            gridTemplateColumns: `repeat(${props.columns}, 1fr)`,
            gridGap: props.gutter,
            paddingLeft: props.margin,
            paddingRight: props.margin,
            paddingTop: verticalMargin,
            paddingBottom: verticalMargin,
        }, "data-testid": props['data-testid'] }, props.children));
}
const getGridColumnStyle = (columnStart, columnSpan) => {
    return columnStart ? `${columnStart} / span ${columnSpan || 1}` : `span ${columnSpan || 1}`;
};
function GridColumn(props) {
    return (react_1.default.createElement("div", { className: `e-grid-column e-grid-column-${props.columnSpan} ${props.className || ''}`, style: { gridColumn: getGridColumnStyle(props.columnStart, props.columnSpan) } }, props.children));
}
//# sourceMappingURL=responsive-grid.js.map