"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useDeepCompareEffect = useDeepCompareEffect;
const lodash_1 = require("lodash");
const react_1 = require("react");
const use_custom_compare_effect_1 = require("./use-custom-compare-effect");
/**
 * Like `useEffect`, but uses `lodash/isEqual` comparator function to validate deep
 * dependency changes.
 *
 * @param callback Function that will be passed to the underlying effect hook.
 * @param deps Dependency list like the one passed to `useEffect`.
 * @param effectHook Effect hook that will be used to run
 * `callback`. Must match the type signature of `useEffect`, meaning that the `callback` should be
 * placed as the first argument and the dependency list as second.
 * @param effectHookRestArgs Extra arguments that are passed to the `effectHook`
 * after the `callback` and the dependency list.
 */
function useDeepCompareEffect(callback, deps, effectHook = react_1.useEffect, ...effectHookRestArgs) {
    (0, use_custom_compare_effect_1.useCustomCompareEffect)(callback, deps, lodash_1.isEqual, effectHook, ...effectHookRestArgs);
}
//# sourceMappingURL=use-deep-compare-effect.js.map