"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCustomCompareEffect = useCustomCompareEffect;
const react_1 = require("react");
const utils_1 = require("./utils");
/**
 * Like `useEffect` but uses provided comparator function to validate dependency changes.
 *
 * @param callback Function that will be passed to the underlying effect hook.
 * @param deps Dependency list like the one passed to `useEffect`.
 * @param comparator Function that compares two dependency arrays,
 * and returns `true` if they're equal.
 * @param effectHook Effect hook that will be used to run
 * `callback`. Must match the type signature of `useEffect`, meaning that the `callback` should be
 * placed as the first argument and the dependency list as second.
 * @param effectHookRestArgs Extra arguments that are passed to the `effectHook`
 * after the `callback` and the dependency list.
 */
// eslint-disable-next-line max-params
function useCustomCompareEffect(callback, deps, comparator = utils_1.basicDepsComparator, effectHook = react_1.useEffect, ...effectHookRestArgs) {
    const dependencies = (0, react_1.useRef)();
    // Effects are not run during SSR, therefore, it makes no sense to invoke the comparator
    if (dependencies.current === undefined || (utils_1.isBrowser && !comparator(dependencies.current, deps))) {
        dependencies.current = deps;
    }
    effectHook(callback, dependencies.current, ...effectHookRestArgs);
}
//# sourceMappingURL=use-custom-compare-effect.js.map